PROCEDURE SelectSort
  (Scores: IN OUT ScoreArray; ClassSize: IN ClassRange) IS
  -- Pre:  Scores and ClassSize are defined
  -- Post: The first ClassSize elements of Scores 
  --   are sorted in descending order

  IndexOfMax: ClassRange;

BEGIN

  FOR PositionToFill IN 1..ClassSize - 1 LOOP

    -- Find the element in subarray PositionToFill..ClassSize
    -- with largest Score
    IndexOfMax := PositionToFill;
    FOR ItemToCompare IN PositionToFill .. ClassSize LOOP
      IF Scores(ItemToCompare) > Scores(IndexOfMax) THEN
        IndexOfMax := ItemToCompare;
      END IF;
    END LOOP;
    -- assert: element at IndexOfMax is largest in subarray

    IF IndexOfMax /= PositionToFill THEN
      Exchange(Scores(PositionToFill),Scores(IndexOfMax));
    END IF;

  END LOOP;

END SelectSort;


