SEPARATE (BST_Threaded_Generic)
PROCEDURE Traverse_LNR (T: Tree) IS
------------------------------------------------------------------------
--| Nonrecursive Traverse_LNR for Threaded BST 
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  Current : Tree;
  Previous: Tree;

BEGIN -- Traverse_LNR
 
  Current := T;

  LOOP
    Previous := NULL;
 
    -- down left branch to bottom
    WHILE Current /= NULL LOOP
      Previous := Current;
      Current := Current.Left;
    END LOOP;

    IF Previous /= NULL THEN
      Visit(Previous.Info);
      Current := Previous.Right;

      -- now back up following threads
      WHILE Previous.Thread LOOP
        Visit (Current.Info);
        Previous := Current;
        Current := Previous.Right;
      END LOOP;
    END IF;

    EXIT WHEN Previous = NULL;

  END LOOP;
       
END Traverse_LNR;
