WITH Ada.Text_IO;
PACKAGE Debugging_Support IS
------------------------------------------------------------------------
--| Package Giving Operations Useful for Debugging Other Packages
--| WITH-ed by the body of a package to provide an easy way to
--| trace calls and returns from subprograms;
--| WITH-ed by a client of the package only to turn debugging on.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  TYPE Switch IS (Off, On);

  PROCEDURE SetDebug(WhichWay: IN Switch; FileName: String := "");
  -- Pre:  WhichWay is defined
  -- Post: Debugging support is turned On or Off, as the case may be;
  --       If FileName = "", debugging output goes to Standard_Output;
  --       otherwise, debugging output goes to the given file.

  PROCEDURE Enter(Subprogram: IN String; Message: IN String := "");
  -- Pre:  Subprogram is defined
  -- Post: Writes a message to Standard_Output or an external file
  --       Enter is not intended as a user operation, but should
  --       be called only from within a package being debugged.

  PROCEDURE Leave(Subprogram: IN String; Message: IN String := "");
  -- Pre:  Subprogram is defined
  -- Post: Writes a message to Standard_Output or an external file
  --       Leave is not intended as a user operation, but should
  --       be called only from within a package being debugged.

END Debugging_Support;
