SEPARATE (Digraphs_Generic)
PROCEDURE Traverse_BFS (G: IN Digraph; Start: Vertices) IS
------------------------------------------------------------------------
--| Breadth_First_Search procedure, subunit of Digraphs_Generic
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  Visited      : VertexSets.Set;
  Source, Dest : Vertices;
  Q            : VertexQueues.Queue(Capacity => 
                   Vertices'Pos(Vertices'Last)  
                 - Vertices'Pos(Vertices'First) 
                 + 1);

BEGIN -- Traverse_BFS

  Visit (Start);
  Visited := Visited + Start;
  Enqueue (Q, start);
  WHILE NOT IsEmpty (Q) LOOP
    Source := First (Q);
    Dequeue (Q);
    FOR Dest IN Vertices LOOP
      IF IsAdjacent (G, Source, Dest) AND NOT IsIn (Visited, Dest) THEN
        Visit (Dest);
        Visited := Visited + Dest;
        Enqueue (Q, Dest);
      END IF;
    END LOOP;
  END LOOP;

END Traverse_BFS;
