WITH Ada.Text_IO, VStrings;
PACKAGE English_Lexer IS
------------------------------------------------------------------------
--| Simple English Lexical Scanner
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  MaxWordSize : CONSTANT Positive := 20;
  SUBTYPE WordType IS VStrings.VString(MaxLength => MaxWordSize);

  PROCEDURE GetWord (F    : IN Ada.Text_IO.File_Type;
             Word   : OUT WordType;
             Success: OUT Boolean;
             EOL    : OUT Boolean;
             EOF    : OUT Boolean);
  -- Pre:  F is defined
  -- Post: reads the next simple English word from F, returning
  --   it in Word. Success is True if and only if Word is non-empty.
  --   EOL is True if and only if the end of the current line was 
  --   reached; EOF is true if and only if end of file was reached.

END English_Lexer;
