WITH Swap_Generic;
PROCEDURE Sort_Bubble_Generic(List: IN OUT ListType) IS
------------------------------------------------------------------------
--| Body of generic Bubble Sort Procedure
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  PROCEDURE Exchange IS NEW Swap_Generic(ValueType => ElementType);
  
  AnotherPassNeeded: Boolean := True;
  CurrentBottom: IndexType := List'Last;
  
BEGIN -- Sort_Bubble_Generic

  WHILE AnotherPassNeeded LOOP
  
    AnotherPassNeeded := False;
  
    FOR Current IN List'First .. CurrentBottom - 1 LOOP
      IF KeyOf(List(Current + 1)) < KeyOf(List(Current)) THEN
        Exchange(List(Current), List(Current + 1));
        AnotherPassNeeded := True;
      END IF;
    END LOOP;

  END LOOP;

END Sort_Bubble_Generic;
