WITH Ada.Text_IO;  USE Ada.Text_IO;
WITH Rationals;    USE Rationals;    
WITH Rationals.IO; USE Rationals.IO;
PROCEDURE Test_Rationals_2 IS
------------------------------------------------------------------
--|                                                              
--| Tests the package Rationals, 
--| this time with USE clause and an exception handler
--|                                                              
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
--|                                                              
------------------------------------------------------------------

  A: Rational;
  B: Rational;
  C: Rational;
  D: Rational;
  E: Rationals.Rational;
  F: Rationals.Rational;

BEGIN -- Test_Rationals_2

  A := 1/3;
  B := 2/(-4);
  Put(Item => "A = ");
  Rationals.IO.Put(Item => A);
  New_Line;
  Put(Item => "B = ");
  Rationals.IO.Put(Item => B);
  New_Line;

  -- Read in rational numbers C and D.   
  Put(Item => "Enter rational number C > ");
  Get(Item => C);
  Put(Item => "Enter rational number D > ");
  Get(Item => D);
  New_Line;

  E := A + B;                   -- form the sum   
  Put(Item => "E = A + B is ");
  Put(Item => E);  
  New_Line;

  F := C * D;                   -- form the product
  Put(Item => "F = C * D is ");
  Put(Item => F);  
  New_Line;

  Put(Item => "A + E * F is ");
  Put(Item => A + E * F);
  New_Line;

EXCEPTION

  WHEN ZeroDenominator =>
    Ada.Text_IO.Put(Item => 
      "Zero not allowed in denominator; terminating program.");
    Ada.Text_IO.New_Line;

END Test_Rationals_2;

