TITLE           MS-DOS: Load & Execute immediately (Int 21,AX = 4B00)

  comment       |

                written and released into the public domain by
                Knut Petersen, 35274 Kirchhain, Germany
                Fidonet#2:244/4351.0

                This code demonstrates how to use the DOS function
                4B, subfunction 0, "Load and Execute". It passes all
                command line parameters to the child process FooBar.Exe
                and returns to DOS with the return code of this child
                process. Custom critical error, <ctrl-c> and <ctrl-break>
                exception handlers are included (ctrl-c and ctrl-break
                are ignored and that the critical error handler always
                returns "failed").

                Assembler: MASM 5.1, 5.1A and 6.00b told me that there isn't
                an error, you will have to edit the REQPARAS definition if
                you use early versions of MASM, TASM or something else.
                It's afaik impossible to write the REQPARAS equate in a way
                that is understandable to MASM 1.1 .. 6.x and TASM 1.x .. 4.x
                :-( MASM 3.x .. 6.x compatibility is possible, but the syntax
                I found produced wrong results without error messages or
                warnings if other assemblers were used. Early versions of
                ML 6.00 will be unable to find the correct result, but the
                result is usable because it's guaranteed to be greater than
                necessary ...

                |

 .radix         16

  STACKPARAS    equ     20

text            segment byte public 'code'
  assume        ds:text, es:text, cs:text

  fcb           db      0, 0bh dup (20),0,0,0,0 ; dummy file control block
  parablk       dw      0                       ; |> use default EnvSeg
                dw      80                      ; |\ dd ptr to comtail
  pspseg        dw      ?                       ; |/
                dd      fcb                     ; |> 1st fcb ptr
                dd      fcb                     ; |> 2nd fcb ptr
  program       db      'FOOBAR.EXE',0          ; |> asciiz program path

  stckofs       dw      ?                       ; used by our exec code to
  stckseg       dw      ?                       ; store ss/sp

  old_i1b_o     dw      ?                       ; will be used to store the
  old_i1b_s     dw      ?                       ; original int 1b vector

  i1b           proc    far                     ; <ctrl-break> handler
                iret                            ; ... ignore it
  i1b           endp

  i23           proc    far                     ; <ctrl-c> handler
                iret                            ; ... ignore it
  i23           endp

  i24           proc    far                     ; critical error handler
                mov     al,3                    ; ... always return "fail"
                iret
  i24           endp

  start:        mov     ah,4a                   ; release unused memory
                mov     bx,REQPARAS
                int     21

                push    cs                      ; ds = seg text
                pop     ds
                mov     [pspseg],es             ; store pspseg in parablk

                mov     ax,351bh                ; get original int 1b vector
                int     21                      ; and save it for later use
                mov     [old_i1b_o],bx
                mov     [old_i1b_s],es
                mov     ax,251Bh                ; install <ctrl-break>
                mov     dx,offset i1b           ; handler
                int     21
                mov     ax,2523                 ; install <ctrl-c>
                mov     dx,offset i23           ; handler
                int     21
                mov     ax,2524                 ; install critical error
                mov     dx,offset i24           ; handler
                int     21

                push    cs                      ; es = seg text
                pop     es
                mov     [stckofs],sp
                mov     [stckseg],ss
                mov     ax,4b00                 ; load & exec child process
                mov     bx,offset parablk
                mov     dx,offset program
                int     21
                cli                             ; remember: old 8088 cpu bug
                mov     ss,cs:[stckseg]         ; remember: old dos 2.x bug
                mov     sp,cs:[stckofs]         ; only cs:ip is valid after
                sti                             ; function 4b00 :-(

                mov     ah,4dh                  ; get return code of child
                int     21                      ; process ...
                push    ax                      ; ... save it
                mov     ax,251Bh                ; restore int 1b handler
                lds     dx,dword ptr [old_i1b_o]; (DOS will restore the int
                int     21                      ; 23&24 vectors)
                pop     ax                      ; restore return code
                mov     ah,4c                   ; and terminate this little
                int     21                      ; demo.

  REQPARAS      equ     ((($-offset[text:0])+10f) shr 4) + STACKPARAS
text            ends


stack           segment para stack
                db      (STACKPARAS shl 4) dup  (?)
stack           ends

end             start

