;
; GRDB
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
;
; help.asm
;
; Function: Handle help and most of the status screens
;
;   Handles numbers
;   Handles segments
;   Handles trapping page faults
;   Handles command input
;
	;MASM MODE
	.model small
	.386

include  iversion.inc
include  eprints.inc 
include  emtrap.inc 
include  eenv.inc
include  eloader.inc
include  einput.inc
include edos.inc
include eoptions.inc
include eints.inc

	extrn cpumodel : byte
	PUBLIC  help

	.data
memx	dw	0	; used to filter non-program stuff in arena dump (?m)
none	db	"none",0
cputypes db	"386",0,"486",0,"Pentium",0
	db	"Pentium Pro",0,"786",0,"886",0,"986",0

	.code
;
; help command entry point
;
Help	PROC
;	call	PrintFollowingMessage
;	db	13,10,"Get Real Debugger Version "
;	db	30h + verid/10,'.',30h + verid MOD 10,9
;	db	"Copyright (c) LADsoft",13,10
;	db	0
	call	WadeSpace
	jnz	help2
	call	PrintFollowingMessage
	db	13,10
	db	"a  [address] 			- assemble",13,10
	db	"b  [d][#] 			- Show breakpoint(s)",13,10
	db	"b  [d][-]#,addr[,r/w/x[,len]]	- set or clear a breakpoint",13,10
	db	"d  [start [,end]]		- dump memory",13,10
	db	"e  start [,list]	 	- examine memory",13,10
	db	"g  [=start] [,break]		- run from start (or pos) to break",13,10
	db	"h  val1 [+-*/] val2		- hex arithmetic",13,10
	db	"i[bwd]  port 			- read from port",13,10
	db	"l  [@] [-] [name[ command]]	- read from file",13,10
	db	"n  [s]				- show fp regs/status",13,10
	db	"n  #, val			- set value in an FP reg",13,10
	db	"o[bwd]  port,val		- write to port",13,10
	db	"p  [r]				- step through",13,10
	db	"q				- quit",13,10
	db	"r  [reg[:val]]			- show/modify regs",13,10
	db	"t  [count]			- step into",13,10
	db	"u  [start [,end]]		- unassemble",13,10
	db	"w  [@addr] [name] [,len]	- write to file",13,10
	db	"?				- this help",13,10
	db	"??				- help for extended commands"
	db	0
	clc
	ret	
help2:
	cmp	al,'?'
	jnz	status
	inc	si
	call	wadespace
	jnz	herr
	call	PrintFollowingMessage
	db	13,10
	db	"c  start,end,start2		- compare memory",13,10
	db	"f  start,end [,val]		- fill memory",13,10
	db	"m  source,end,dest		- move memory",13,10
	db	"s  start,end [,list]		- search for a byte pattern",13,10
	db	"xr drive: addr,start [,len]	- read logical disk sector",13,10
	db	"xw drive: addr,start [,len]	- write logical disk sector",13,10
	db	"y  pfa,reg[,val]               - read/[write] PCI reg",13,10
	db	"y? bus, dev, func	        - get PFA from bus:dev:func",13,10
	db	"@  [a] [logfile]		- start/stop logging to a file",13,10
	db	"?i				- view interrupt info",13,10
	db	"?m [x]				- view arena tags",13,10
	db	"?o [+-option]			- view/set options",13,10
	db	"?p				- view program status"
	db	0
	clc
	ret	
;
; program & processor info
;
status:
	cmp	al,'p'
	jnz	hmem
	inc	si
	call	WadeSpace
	jnz	herr
	PRINT_MESSAGE	<13,10,"Dos version: ">
	mov	al,byte ptr [dosver + 1]
	call	printbyte
	mov	dl,'.'
	call	putchar
	mov	al,byte ptr [dosver]
	call	printbyte
	PRINT_MESSAGE	<13,10,"CPU type: ">
	mov	di,offset cputypes ; calculate CPU type message pos
	movzx	cx,[cpumodel]		; program needs a 386+ :)
	sub	cx,3
	jcxz	gotcpu
	sub	al,al
cpulp:
	push	cx
	mov 	cx,-1
	repne	scasb
	pop	cx
	loop	cpulp

gotcpu:
	mov	bx,di 		; put out CPU type
	call	dgroupMessage     

	call	crlf

	mov	si,offset loadfile	; calc loadfile and command
	mov	di,offset loadcommand
	test	[filelen],-1
	jnz	okprog
	mov	si,offset none
	mov	di,si
okprog:
	test	byte ptr [di],-1
	jnz	okgotdi
	mov	di,offset none
okgotdi:
	test	byte ptr [si],-1
	jnz	okgotsi
	mov	si,offset none
okgotsi:
	PRINT_MESSAGE	<13,10,"Program:   ">
	mov	bx,si
	call	DgroupMessage
	PRINT_MESSAGE	<13,10,"Arguments: ">
	mov	bx,di
	call	DgroupMessage
	call	ExeStats			; put out EXE file stats
	call	crlf

	PRINT_MESSAGE	<13,10,"Psp at ">
	mov	ax,[userbasepsp]
	call	PrintWord
	mov	ax,[userpsp]
	cmp	ax,[userbasepsp]
	jz	normpsp
	push	ax              		; display if they have changed it
	call	printspace
	mov	dl,'('
	call	PutChar
	pop	ax
	call	PrintWord
	mov	dl,')'
	call	PutChar
	call	printspace
normpsp:
	PRINT_MESSAGE	<" with length ">
	mov	ax,[userbasepsp]
	dec	ax
	mov	fs,ax
	mov	ax,fs:[3]
	call	PrintWord
	PRINT_MESSAGE	<13,10,"Environment at ">
	mov	ax,[TgtPgmEnvSeg]
	call	PrintWord
	PRINT_MESSAGE	<" with ">
	mov	ax,[TgtPgmEnvSpaceUsed]
	call	Printword
	PRINT_MESSAGE	<" bytes used of ">
	mov	ax,[TgtPgmEnvLen]
	call	PrintWord
	
	clc
	ret		
;
; arena stats
;
hmem:	cmp	al,'m'
	jnz	hopt
	mov	ax,[userbasepsp]		; calc PSP match
	mov	[memx],ax
	inc	si
	call	WadeSpace
	jz	memok
	cmp	al,'x'
	jnz	herr
	inc	si
	call	WadeSpace
	jnz	herr
	mov	[memx],0
memok:
	PRINT_MESSAGE	<13,10,13,10,"Top of memory: ">
	mov	fs,[userbasepsp]
	mov	ax,fs:[2]
	call	PrintWord
	call	crlf
	push	es 				; get root of chain      			
	mov	ah,52h	
	int	21h
	mov	bx,es:[bx-2]
	pop	es
meml:
	mov	fs,bx
	test	[memx],0ffffh			; check match and jump around if not
	jz	memd
	mov	ax,fs:[1]
	cmp	ax,[memx]
	jnz	memnd
memd:
	PRINT_MESSAGE	<13,10,"Address: ">
	mov	ax,fs
	call	PrintWord
	PRINT_MESSAGE	<"  Owner: ">
	test	word ptr fs:[1],-1
	jz	memu
	cmp	word ptr fs:[1],100h
	jc	memdos
	cmp	word ptr fs:[1],0f000h
	jnc	membios
	push	fs    				; not special
	mov	bx,fs:[1]			; display prog name owner
	dec	bx
	mov	fs,bx
	mov	si,8
	mov	cx,8
memns:
	lods	byte ptr fs:[si]
	or	al,al
	jz	memnsx
	mov	dl,al
	call	PutChar
	loop	memns
memnsx:
	pop	fs
	inc	cx
	push	cx
	mov	dl,'('
	call	PutChar
	mov	ax,fs:[1]
	call	PrintWord
	mov	dl,')'
	call	PutChar
	jmp	memsz
memdos:                                         ; dos special case
	push	12
	PRINT_MESSAGE	"DOS"
	jmp	memmsg
membios:					; bios special case
	push	11
	PRINT_MESSAGE	"BIOS"
	jmp	memmsg

memu:						; free special case
	push	11
	PRINT_MESSAGE	"FREE"
memmsg:
memsz:
	pop	cx
memspl:
	mov	dl,' '				; field pad
	push	cx
	call	PutChar
	pop	cx
	loop	memspl
	PRINT_MESSAGE	"  Size: "
	mov	ax,fs:[3]
	call	PrintWord
	mov	bx,fs
memnd:
	add	bx,fs:[3]			; index to next entry
	inc	bx
	cmp	byte ptr fs:[0],'Z'		; quit if this entry was EOM
	jnz	meml
	clc
	ret
;
; option status, jump to option routine
;
hopt:
	cmp	al,'o'
	jnz	hchain
	inc	si
	jmp	doopt
;
; chain status
;
hchain:
	cmp	al,'i'
	jnz	herr
	inc	si
	call	wadespace
	jnz	herr
	inc	si
	call	crlf
	push	es
	mov	es,[intpage]
	sub	ax,ax
	mov	gs,ax
	mov	cx,256
	sub	si,si
	sub	di,di
chl:
	lods	dword ptr gs:[si]	; compare currint int page entry
	scasd
	jz	noch
	push	si
	push	di
	push	eax			; mismatch, print int #
	mov	al,cl
	neg	al
	push	ax
	call	printbyte
	pop	ax
	cmp	al,21h			; int 21h is modifiable
	jz	nostar
	or	al,al 			; so are all ints > 7FH
	js	nostar
	push	es
	push	ds
	pop	es
	mov	di,offset veclist
chlx:
	scasb
	jz	dostar
	inc	di
	inc	di
	cmp	byte ptr [di],0ffh
	jnz	chlx
	pop	es
nostar:
	call	printspace		; not overridden
	jmp	chj
dostar:
	pop	es
	mov	dl,'*'
	call	putchar
chj:                                    ; print int vect address
	mov	dl,':'
	call	putchar
	call	printspace
	pop	bx
	pop	ax
	call	printword
	mov	dl,':'
	call	putchar
	mov	ax,bx
	call	printword
	call	crlf
	pop	di
	pop	si
noch:
	loop	chl
	pop	es
	PRINT_MESSAGE	<13,10,"PIC 0 mask: ">
	mov	dx,21h
	mov	ah,byte ptr [orgpic+1]
	call	picval
	PRINT_MESSAGE	<13,10,"PIC 1 mask: ">
	mov	dx,0a1h
	mov	ah,byte ptr [orgpic]
	call	picval
	clc
	ret
picval:
	push	ax
	in	al,dx
	push	dx
	call	printbyte
	call	printspace
	mov	dl,'(' 
	call	putchar
	pop	dx
	pop	ax
	push	dx
	mov	al,ah
	call	printbyte
	mov	dl,',' 
	call	putchar
	pop	dx
	dec	dx
	mov	al,0bh
	out	dx,al
	in	al,dx
	call	printbyte
	mov	dl,')' 
	call	putchar
	ret
herr:
	stc
	ret
Help	ENDP
END