;****************************************************************************
;Version Number         :       1.01a
;Assembler & Version    :       MASM 6.11, LINK 5.60.399
;Brief Description      :       This file contains the assembly routine
;                       :       EXECUTE which takes the INT No. as one of the
;                       :       input parameters and executes that particular
;                       :       interrupt.It is capable of executing any
;                       :       interrupt passed to it with other input
;                       :       register values.
;****************************************************************************

.model small,C

.data
        str db 0CDh,?,0CBh
.code

PUBLIC execute

;****************************************************************************
;Register Usage         :       All Registers are destroyed
;Brief Description      :       The routine takes the Interrupt no. to be
;                       :       executed along with the register values and
;                       :       executes that interrupt.
;****************************************************************************

execute PROC NEAR INTNO: BYTE, AXVAL: WORD, BXVAL: WORD, CXVAL: WORD,
DXVAL: WORD, FLAGVAL: WORD

        mov ax,@data
        mov ds,ax

;The catch is here!!
        mov ah,INTNO
        mov ds:[str+1],ah

        mov    ax,AXVAL         ;Initialize AX
        mov    bx,BXVAL         ;Initialize BX 
        mov    cx,CXVAL         ;Initialize CX
        mov    dx,DXVAL         ;Initialize DX

        push    ax
        mov     ax,FLAGVAL      ;Initialize Flags
        push    ax
        popf
        pop     ax

;And finally call it!!
        
        call far ptr ds:[str]

        ret
execute ENDP

END
