;
; Copyright (C) 2000 Grzegorz Kowal
;

.486
CODE32  SEGMENT PUBLIC PARA USE32 'CODE'
ASSUME  CS:CODE32,DS:CODE32,ES:CODE32

INCLUDE	DEMO.ASH			; header file

Start32:
	VESAInit			; init the library (NESSECARY!)
	SetMode 2			; set 800x600x256 mode
	MouseInit			; init mouse
	mov	eax,O Font
	mov	WindowFont,eax		; set window (dialog) font
	mov	eax,O Font
	mov	ButtonFont,eax		; set button font
	ButtonCol 243,244,245,246,247,248,249	; set colors
	WindowCol 250,251,252,253
	FrameCol 250,251

	mov	ebx,O Picture		; get filespec
	stc				; center image
	call	ShowGif			; Presto!
	jc	Error			; just in  case...

	mov	ecx,48			; set colors 240-255
	mov	esi,O Pal		; we don't use the SetPal function
	mov	dx,3C8h			; because we change the last 16 colors
	mov	al,240
	out	dx,al
	inc	dx
rep	outsb

	mov	ebx,O Dlg1
	call	PutDialog
	jc	Error

	mov	ebx,O Dlg2
	call	PutDialog
	jc	Error

	mov	ebx,O Dlg3
	call	PutDialog
	jc	Error

	mov	ebx,O MenuDemo
	call	PutDialog
	jc	Error

	mov	al,255
	mov	ecx,175
	mov	edx,254
	mov	esi,O Text
	mov	ebx,O Font
	call	PutGpxText
	jc	Error
	mov	ah,allocate_memory
	mov	edx,800*540
	Int_EOS
	jc	MemError
	mov	MemAdd,edx
	MouseOff
	mov	edi,edx
	mov	ecx,0			; X-Pos
	mov	edx,0			; Y-Pos
	mov	eax,800			; X-Size
	mov	ebx,540			; Y-Size
	call	GetBlock
	jc	Error
	MouseOn
	mov	al,245			; color
	mov	ecx,0			; X1
	mov	edx,540			; Y2
	mov	esi,799			; X2
	mov	edi,540			; Y2
	call	PutLine
	jc	Error
	mov	ScrollUp,O Upf		; your functions
	mov 	ScrollDown,O Downf	;
	mov	ScrollLeft,O Leftf	;
	mov	ScrollRight,O Rightf	;
	ScrollOn
ButtonLoop:
	mov	ebx,O QuitScrolling
	mov	edx,0			; ignore right mouse button
	mov	eax,O KeybHandler2
	call	UseButtons
	jnc	ButtonLoop

StopScrolling:
	call	Dealloc
	mov	ebx,O EndDlg
	call	PutDialog
	jc	Error

TheEnd:
	Term				; normal program end, disables the
					; mouse driver extention (important),
					; returns to text video mode, and so on


; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Scrolling functions
;
Upf:
	cld
	mov	esi,MemAdd
	mov	edi,O Buffer
	mov	ecx,800
rep	movsd
	mov	edi,MemAdd
	mov	esi,edi
	add	esi,800*4
	mov	ecx,800*536/4
rep	movsd
	mov	esi,O Buffer
	mov	edi,MemAdd
	add	edi,800*536
	mov	ecx,800
rep	movsd
	Call	ShowIt
	ret


Downf:
	mov	esi,MemAdd
	add	esi,800*536
	mov	edi,O Buffer
	mov	ecx,800
	cld
rep	movsd
	mov	edi,MemAdd
	mov	esi,edi
	add	esi,800*536-4
	add	edi,800*540-4
	mov	ecx,800*536/4
	std
rep	movsd
	mov	esi,O Buffer
	mov	edi,MemAdd
	mov	ecx,800
	cld
rep	movsd
	Call	ShowIt
	ret


Leftf:
	mov	esi,MemAdd
	mov	edi,esi
	cld
	mov	edx,540
NextLine1:
	lodsd
	mov	ebx,eax
	mov	ecx,796/4
rep	movsd
	mov	eax,ebx
	stosd
	dec	edx
	jnz	NextLine1
	call	ShowIt
	ret


Rightf:
	mov	esi,MemAdd
	add	esi,800*540-4
	mov	edi,esi
	std
	mov	edx,540
NextLine2:
	lodsd
	mov	ebx,eax
	mov	ecx,796/4
rep	movsd
	mov	eax,ebx
	stosd
	dec	edx
	jnz	NextLine2
	call	ShowIt
	ret


ShowIt:
	MouseOff
	mov	dx,3DAh			; the PutBlock function has its own
Wait0:					; raster sync, but it uses the Eclipse
	in	al,dx			; Wait_Vbl func to do it, and I'm not
	test	al,8			; sure if it works right. (It flickered
	jz	Wait0			; on some computers). So this time I
					; used the old way to do it.

	mov	ecx,0			; X-Pos
	mov	edx,0			; Y-Pos
	mov	eax,800			; X-Size
	mov	ebx,540			; Y-Size
	mov	esi,MemAdd
;					;                              ^^^
;	stc				; raster sync (may flicker on some PCs)
;					; it might be an error in the Eclipse
;					; func Wait_Vbl.
	call	PutBlock
	jc	Error
	MouseOn
	ret


; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Deallocate memory
;
Dealloc:
	cmp	MemAdd,0
	jz	Finished
	mov 	ah,deallocate_memory
	Int_EOS
Finished:
	ret


; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Menu procdeure
;
Menu1:
	add	al,'1'
	mov	B MenuItem,al
	mov	ebx,O InfoDlg
	call	PutDialog
	jc	Error
	retc


; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Keyboard handler
;
KeybHandler:
	cmp	al,27			; ESC key?
	je	XClose
	retc				; no, continue.

KeybHandler2:
	cmp	al,27			; ESC key?
	je	XClose2
	retc				; no, continue.


; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; X-close button
;
XClose:
	mov	ebx,O AskUser
	call	PutDialog
	jc	Error
	retc

XClose2:
	mov	ebx,O AskUser2
	call	PutDialog
	jc	Error
	retc

AskUserKeyb:
	cmp	al,27
	je	LeaveDlg
	retc

LeaveDlg:
	retx

Quit:
	call	Dealloc
	Term				; exit to DOS


; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Button that beeps
;
BeepButt:
	MouseBusyCur
	putchar 7
	MouseReadyCur
	retc


; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Error handler
;
Error:
	Kill	ErrorM

MemError:
	Kill	ErrorM2


; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; DATA
;
MemAdd	DD	0
Picture	DB	"demo.gif",0
ErrorM	DB	"An error has ocurred!",0Dh,0Ah,'$'
ErrorM2	DB	"Out of memory!",0Dh,0Ah,'$'
Text	DB	"SCROLL DEMO",0Ah,"Try moving the mouse cursor to the screen edges...",0

INCLUDE DEMO.PAL
INCLUDE DEMO.DLG			; include the dialog def file
INCLUDE DEMO.FNT			; include the font file

Buffer	DB	800*4 DUP(?)
CODE32  ENDS
        END
