/* ASMPRINT.C -- formatted printing of assembler code files */

#include <stdio.h>
#include <string.h>
#include <ctype.h>

char *bold = "\x1b\x45";
char *norm = "\x1b\x46\x1b\x35";
char *ital = "\x1b\x34";
char *skip = "\x0c";
char *word_continuer = "_?@";

#define TRUE -1
#define FALSE 0

char *reserved_list[] = {
                         "aaa", "aad", "aam", "aas", "adc", "add",
                         "and", "bsf", "bsr", "bt" , "btc", "btr",
                         "bts", "call", "cbw", "cdq", "clc", "cld",
                         "cli", "cmc", "cmp", "cmps", "cmpsb", "cmpsw",
                         "cmpsd", "cwd", "cwde", "daa", "das", "dec",
                         "div", "esc", "hlt", "idiv", "imul", "in",
                         "inc", "int", "into", "iret", "iretd", "ja",
                         "jae", "jb", "jbe", "jc", "jcxz", "jecxz",
                         "je", "jg", "jge", "jl", "jle", "jmp",
                         "jna", "jnae", "jnb", "jnbe", "jnc", "jne",
                         "jng", "jnge", "jnl", "jnle", "jno", "jnp",
                         "jns", "jnz", "jo", "jpo", "jp", "jpe",
                         "js", "jz", "lds", "lea", "les", "lfs",
                         "lgs", "lock", "lods", "lodsb", "lodsd", "lodsw",
                         "loop", "loopd", "loope", "loopz", "loopne", "loopnz",
                         "loopw", "lss", "mov", "movs", "movsb", "movsd",
                         "movsw", "movsx", "movzx", "mul", "or", "out",
                         "pop", "popa", "popad", "popf", "popfd", "push",
                         "pusha", "pushad", "pushfd", "rcl", "rcr", "rep",
                         "repe", "repz", "repne", "repnz", "ret", "retn",
                         "retf", "rol", "ror", "sahf", "lahf", "sal",
                         "sar", "sbb", "scas", "scasb", "scasd", "scasw",
                         "shl", "shld", "shr", "shrd", "stc", "std",
                         "sti", "stos", "stosb", "stosd", "stosw", "sub",
                         "test", "wait", "xchg", "xlat", "xlatb", "xor",
                         "neg", "not", "nop",

                         "ax", "bx", "cx", "dx", "si", "di",
                         "sp", "bp", "cs", "ss", "es", "ds",
                         "ah", "al", "bh", "bl", "ch", "cl",
                         "dh", "dl", "eax", "ebx", "ecx", "edx",
                         "esi", "edi", "esp", "ebp", "fs", "gs",


                         "assume", "align", "at", "byte", "comm", "common",
                         "db", "dd", "df", "dq", "dt", "dw",
                         "dword", "else", "end", "endif", "endp", "ends",
                         "equ", "even", "exitm", "extrn", "far", "fword",
                         "group", "high", "if", "if1", "if2", "ifb",
                         "ifnb", "ifdef", "ifndef", "ifdif", "ifdifi", "ifidn",
                         "ifidni", "ife", "include", "irp", "irpc", "label",
                         "length", "list", "local", "low", "mask", "near",
                         "none", "nothing", "offset", "org", "page", "para",
                         "proc", "ptr", "public", "purge", "qword", "radix",
                         "record", "rept", "endm", "seg", "segment", "short",
                         "size", "stack", "struc", "subttl", "this", "title",
                         "type", "use16", "use32", "width", "word",

                         "eq", "gt", "lt", "ne", "macro", "mod",
                        };

#define MAX (25*6 + 5*6 + 12*6 + 8+6)

unsigned char word_continue (char c) {
    unsigned i;
    unsigned char result = FALSE;

    for (i = 0; (i < strlen (word_continuer)) && (result == FALSE); ++i)
        result = (unsigned char) (c == word_continuer[i]);

    return result;
}

void get_word (char *line, char *word) {
    unsigned i;

    for (i = 0; (isalpha (line[i])) || (isdigit (line[i])) || word_continue (line[i]); ++i) {
        word[i] = line[i];
    }

    word[i] = '\0';
}

unsigned char reserved (char *word) {
    unsigned i = 0;
    unsigned is_resvd = 1;

    while ((i < MAX) && (is_resvd != 0)) {
        is_resvd = stricmp (reserved_list[i], word);
        ++i;
    }

    return (is_resvd == 0) ? TRUE:FALSE;
}

void process_line (char *in_line, char *out_line) {
    unsigned char in_string, in_comment;
    char ch, open_quote;
    unsigned int i, j;
    char word[30];

    i = j = 0;
    in_string = in_comment = FALSE;

    while (in_line[i] != '\0') {
        ch = in_line[i];

        if (((ch == 0x22) || (ch == 0x27)) && in_string) {
            if (open_quote == ch) {
               in_string = ~in_string;
            }
        }
        else if ((ch == 0x22) || (ch == 0x27)) {
            open_quote = ch;
            in_string = TRUE;
        }

        if (in_string == FALSE) {
            if (ch == ';') {
                in_comment = TRUE;
                strcpy (out_line+j, ital);
                j += strlen (ital);
                strcpy (out_line+j, in_line+i);
                j += strlen (in_line+i);
                strcpy (out_line+j, norm);
                j += strlen (norm);
                i += strlen (in_line+i);
            }

            if (in_comment == FALSE) {
                if (isalpha (ch) || isdigit (ch)) {
                    get_word (in_line+i, word);
                    if (reserved (word)) {
                        strcpy (out_line+j, bold);
                        j += strlen (bold);
                        strcpy (out_line+j, word);
                        j += strlen (word);
                        strcpy (out_line+j, norm);
                        i += strlen (word);
                        j += strlen (norm);
                    }
                    else {
                        strcpy (out_line+j, word);
                        j += strlen (word);
                        i += strlen (word);
                    }
                }
                else {
                    out_line[j] = ch;
                    ++i; ++j;
                }
            }
        }
        else {
            out_line[j] = ch;
            ++i; ++j;
        }
    }
    out_line[j] = '\0';
}

void main (void) {
    char this_line[100];
    char this_line_new[200];
    char *result;
    unsigned line_no = 1;

    while ((result = gets (this_line)) != NULL) {
        process_line (this_line, this_line_new);
        if ((line_no++ % 60) == 0) {
            printf ("%s", skip);
        }

        printf ("%s\n", this_line_new);
    };
}
