 title Mc_Init.Asm: Contains startup & initialization routines for Mystic.

; Authored by ASN 1998-99 (See Read.Me & Mc_Core.Asm for details)

; This module contains the code required to initialise the screen saver, set
; interrupt vectors, and make the program resident in memory. The module also
; determines whether the screen saver is already resident, and if so, aborts
; without making resident another instance of the screen saver.

; Uses INT 69h gateway to the Mystic v1.0 Application Program Interface (API)

; Tested with TASM v3.1 normal settings (no additional switches). Should
; assemble with MASM without any modifications.

.8086                                  ; pure 86/88 assembly code here!
.radix 10                              ; default number base is 10

;-----------------------------------------------------------------------------;
 MC_API_INT            equ     69h     ; Mystic v1.0 API function dispatcher
 MC_SS_API_GATEWAY     equ     00h     ; fn 0 - reset screen saver
 MC_GET_INFO           equ     01h     ; fn 1 - get screen saver info

 DOS_INT               equ     21h     ; DOS function dispatcher
 DOS_PRINT_CHAR        equ     02h     ; print character function
 DOS_KEEP_PROGRAM      equ    3100h    ; DOS keep program function
 DOS_TERMINATE         equ    4c89h    ; terminate program - error code 89h
 DOS_FREE_MEMORY       equ     49h     ; DOS free memory block fn.
 DOS_GET_BUSY_FLAG     equ     34h     ; get inDOS flag
 DOS_ENVIRONMENT       equ    002ch    ; offset of environment address in PSP
 NEW_LINE              equ  <0dh, 0ah> ; CR-LF for NEW_LINE
 BEEP                  equ     07h     ; generates tone
 NULL                  equ     00h     ; null byte

 GET_INT               equ    3500h    ; DOS fn 35h - get INT handler
 SET_INT               equ    2500h    ; DOS fn 25h - set INT handler

 KEYBOARD_INT          equ     09h     ; keyboard interrupt
 TIMER08h_INT          equ     08h     ; timer interrupt
 DOS_IDLE_INT          equ     28h     ; DOS idle interrupt

 NO                    equ     00h     ; define logical constants
 YES                   equ   not (NO)

;----------------------------------------------------------------------------;
 Set_Vector macro INT_NUMBER, New_Handler, Old_Handler
     mov ax, (GET_INT or INT_NUMBER)   ; get address of INT 09h
     int DOS_INT                       ; call DOS - get address
     mov word ptr [Old_Handler], bx    ; save the address of handler
     mov word ptr [Old_Handler+2], es  ; in program variables

     mov ax, (SET_INT or INT_NUMBER)   ; set new INT 09h handler
     lea dx, [New_Handler]             ; load address of new handler
     int DOS_INT                       ; set new handler
                endm

;----------------------------------------------------------------------------;
 Write_Message macro                   ; macro to write an ASCII-Z string
 local Next_Char, Print_Start          ; string assumed to be @ DS:SI
                                       ; AX, SI, DX destroyed
     mov ah, DOS_PRINT_CHAR            ; write char function
     jmp Print_Start

 Next_Char:
     int DOS_INT                       ; call DOS to print char

 Print_Start:
     mov dl, [si]                      ; load next char
     inc si                            ; bump counter
     test dl, dl                       ; is the char NULL?
     jnz Next_Char                     ; if not, print it
               endm

;----------------------------------------------------------------------------;
 _TEXT segment byte public use16 'CODE'
     assume cs:_TEXT, ds:_TEXT, es:nothing, ss:nothing

;----------------------------------------------------------------------------;
 Start_Banner db 'Ŀ', NEW_LINE
              db ' Mystic version 1.0a by ASN 1998 ', NEW_LINE
              db ' MS-DOS screen saver stub module ', NEW_LINE
              db '', NEW_LINE
              db ' Scanning... found '
              db NULL

 Load_Success db 'no active screen saver.', NEW_LINE
              db NULL
 Load_Failure db 'a screen saver!', BEEP, NEW_LINE
              db ' Unable to proceed - aborting...', NEW_LINE
              db NULL

 Hook_Vectors db ' Linking to interrupt vectors...', NEW_LINE
              db NULL

;----------------------------------------------------------------------------;
     public MC_Load_Stub               ; main setup procedure

     extrn SS_Initialize:near          ; performs screen saver init
     extrn SS_Resident_Code_End:byte   ; last byte of resident code is here
     extrn SS_Message:byte             ; screen saver message

 MC_Load_Stub proc near                ; main setup control proc
     push cs                           ; load code segment address
     pop ds                            ;   in DS

     lea si, [Start_Banner]
     Write_Message                     ; print Mystic v1.0 banner

     mov ax, MC_GET_INFO               ; fn 1 - get screen saver info
     int MC_API_INT                    ; call Mystic v1.0 API services
     cmp ah, 0abh                      ; is Mystic already resident?
     je Quit_Without_Installing        ; if it is, simply exit

     lea si, [Load_Success]
     Write_Message                     ; else no screen saver found

     mov ah, DOS_FREE_MEMORY           ; free memory block
     mov es, cs:[DOS_ENVIRONMENT]      ; load environment block in ES
     int DOS_INT                       ; call DOS - free environment block

     lea si, [Hook_Vectors]
     Write_Message
     call MC_Hook_INT_Vectors          ; hook on to interrupt vectors

     lea si, [SS_Message]
     Write_Message                     ; print screen saver intro message

     call SS_Initialize                ; ask screen saver to perform init

     lea dx, [SS_Resident_Code_End]    ; program endpoint
     mov cl, 04h                       ; shift count
     shr dx, cl                        ; divide by 16
     inc dx                            ; one more para for safety
     mov ax, DOS_KEEP_PROGRAM          ; DOS Keep Program function
     int DOS_INT                       ; terminate & stay resident

 Quit_Without_Installing:
     lea si, [Load_Failure]
     Write_Message                     ; write screen saver name

     call SS_Initialize                ; ask screen saver to perform init

     mov ax, DOS_TERMINATE             ; select function 4Ch - terminate
     int DOS_INT                       ; terminate program
 MC_Load_Stub endp

;----------------------------------------------------------------------------;
     extrn MC_Timer_INT_Handler:far    ; replacement handler for INT 08h
     extrn MC_Key_INT_Handler:far      ; replacement handler for INT 09h
     extrn MC_DOS_Idle_Handler:far     ; replacement handler for INT 28h
     extrn MC_API_Handler:far          ; Mystic v1.0 API function dispatcher

     extrn Old_Timer_Handler:dword     ; holds original INT 08h address
     extrn Old_Key_Handler:dword       ; holds original INT 09h address
     extrn Old_DOS_Idle_Handler:dword  ; holds original INT 28h address
     extrn Old_INT69h_Handler:dword    ; holds original INT 69h address
     extrn In_DOS_Flag:dword           ; holds InDOS flag address

 MC_Hook_INT_Vectors proc near         ; initializes interrupt vectors etc.
     cli                               ; installing vectors - disable interrupts

     Set_Vector TIMER08h_INT, MC_Timer_INT_Handler, Old_Timer_Handler
     Set_Vector KEYBOARD_INT, MC_Key_INT_Handler  , Old_Key_Handler
     Set_Vector DOS_IDLE_INT, MC_DOS_Idle_Handler , Old_DOS_Idle_Handler
     Set_Vector MC_API_INT  , MC_API_Handler      , Old_INT69h_Handler

     sti                               ; vectors installed - enable interrupts

     mov ah, DOS_GET_BUSY_FLAG         ; get the inDOS flag address
     int DOS_INT                       ; call DOS - get address
     mov word ptr [In_DOS_Flag], bx    ; save the address of inDOS flag
     mov word ptr [In_DOS_Flag+2], es  ;   in program variables

     retn                              ; return to main
 MC_Hook_INT_Vectors endp

;----------------------------------------------------------------------------;
 _TEXT ends

     end                               ; end of module

;x----------------------------- Mc_Init.Asm --------------------------------x;
