.COMMENT
 ****************************************************************************
 JOYSTICK.ASM   Adaptive joystick routines
                320x200 256 colors mode.
                (c) 1996,1998 by Dieter Pawelczak - Pass32 Version 2.3
 ============================================================================
 ****************************************************************************

.include graph.inc
.include system.mac
.include string.inc
.include game.inc


.DATA
     joyminleft  dd 0 ; the program calculates 16 steps between min and max
     joymaxright dd 0
     joyminhigh  dd 0 ; the program calculates 16 steps between min and max
     joymaxlow   dd 0
     PowerX      db 0,0,0,0        ; graphical display X-Axis
     PowerY      db 0,0,0,0        ; graphical display Y-Axis

     mesg1       db   'JOYSTICK',0
     mesg2       db   'Adaptive Joystick Routines',0
     mesg3       db   '(c) 1998 by D. Pawelczak',0


; Macro to set the Image Offsets

.MACRO SPWX(x1,x2,x3,x4)
  mov Powerx,x1-72        ; 72 is the image offset of the original
  mov Powerx+1,x2-72      ; image file, which is now partly included
  mov Powerx+2,x3-72      ; with BIN2ASM at the end of the file
  mov Powerx+3,x4-72
  ret
ENDMACRO

.MACRO SPWY(x1,x2,x3,x4)
  mov PowerY,x1-72
  mov PowerY+1,x2-72
  mov PowerY+2,x3-72
  mov PowerY+3,x4-72
  ret
ENDMACRO

; Macro to draw an Image

.MACRO DrawImg(x,y,num)
  mov ecx,x*16
  mov edx,y*16
  mov esi,16
  movzx ebx,num
  shl ebx,8
  lea edi,[ebx+offset graphic_objects]
  mov ebx,16
  call putimage
ENDMACRO

.code

PROC CALCX       ; calculates 16 steps between min and max for the X-Axis
  call getxaxis
  cmp joyminleft,eax
  jb short L1
  mov joyminleft,eax
L1:
  cmp joymaxright,eax
  ja short L2
  mov joymaxright,eax
L2:
  ; now calculate 16 steps
  mov ebx,joymaxright
  sub ebx,joyminleft
  ; in ebx joystick Range
  sub eax,joyminleft
  ; in eax current Position
  shr ebx,4
  ; ebx is range div 16
  cmp ebx,0
  je short nodiv
  xor edx,edx
  div ebx
nodiv:
  ; in eax a number between 0 .. 15
  ret
ENDP CALCX

PROC CALCY       ; calculates 16 steps between min and max for the Y-Axis
  call getyaxis
  cmp joyminhigh,eax
  jb short L1
  mov joyminhigh,eax
L1:
  cmp joymaxlow,eax
  ja short L2
  mov joymaxlow,eax
L2:
  ; now calculate 16 steps
  mov ebx,joymaxlow
  sub ebx,joyminhigh
  ; in ebx joystick Range
  sub eax,joyminhigh
  ; in eax current Position
  shr ebx,4
  ; ebx is range div 16
  cmp ebx,0
  je short nodiv
  xor edx,edx
  div ebx
nodiv:
  ; in eax a number between 0 .. 15
  ret
ENDP CALCY



PROC FILLBACKGROUND
  xor edx,edx
L2:
  xor ecx,ecx
L1:
  push ecx
  push edx
  shl ecx,4
  shl edx,4
  mov  edi,offset graphic_objects
  mov  ebx,16
  mov  esi,16
  call putimage
L3:
  pop edx
  pop ecx
  inc ecx
  cmp ecx,20
  jb l1
  inc edx
  cmp edx,12
  jb l2
  ret
  ret
ENDP FILLBACKGROUND

PROC DRAWPOWERX ; draws power line for ranges in eax between 0..15  X-Axis
  push eax
  drawimg(8,11,PowerX)
  drawimg(9,11,PowerX+1)
  drawimg(10,11,PowerX+2)
  drawimg(11,11,PowerX+3)
  pop eax
  cmp al,0
  jne short L1
  SPWX(99,95,100,91)
L1:
  cmp al,1
  jne short L2
  SPWX(98,95,100,91)
L2:
  cmp al,2
  jne short L3
  SPWX(97,95,100,91)
L3:
  cmp al,3
  jne short L4
  SPWX(96,95,100,91)
L4:
  cmp al,4
  jne short L5
  SPWX(91,95,100,91)
L5:
  cmp al,5
  jne short L6
  SPWX(91,94,100,91)
L6:
  cmp al,6
  jne short L7
  SPWX(91,93,100,91)
L7:
  cmp al,7
  jne short L8
  SPWX(91,92,100,91)
L8:
  cmp al,8
  jne short L9
  SPWX(91,92,100,91)
L9:
  cmp al,9
  jne short L10
  SPWX(91,92,101,91)
L10:
  cmp al,10
  jne short L11
  SPWX(91,92,102,91)
L11:
  cmp al,11
  jne short L12
  SPWX(91,92,103,91)
L12:
  cmp al,12
  jne short L13
  SPWX(91,92,103,104)
L13:
  cmp al,13
  jne short L14
  SPWX(91,92,103,105)
L14:
  cmp al,14
  jne short L15
  SPWX(91,92,103,106)
L15:
  SPWX(91,92,103,107)
  ret
ENDP DRAWPOWERX

PROC DRAWPOWERY ; draws power line for ranges in eax between 0..15  Y-Axis
  push eax
  drawimg(19,5,PowerY)
  drawimg(19,6,PowerY+1)
  drawimg(19,7,PowerY+2)
  drawimg(19,8,PowerY+3)
  pop eax
  cmp al,0
  jne short L1
  SPWY(82,78,83,74)
L1:
  cmp al,1
  jne short L2
  SPWY(81,78,83,74)
L2:
  cmp al,2
  jne short L3
  SPWY(80,78,83,74)
L3:
  cmp al,3
  jne short L4
  SPWY(79,78,83,74)
L4:
  cmp al,4
  jne short L5
  SPWY(74,77,83,74)
L5:
  cmp al,5
  jne short L6
  SPWY(74,76,83,74)
L6:
  cmp al,6
  jne short L7
  SPWY(74,75,83,74)
L7:
  cmp al,7
  jne short L8
  SPWY(74,75,83,74)
L8:
  cmp al,8
  jne short L9
  SPWY(74,75,83,74)
L9:
  cmp al,9
  jne short L10
  SPWY(74,75,84,74)
L10:
  cmp al,10
  jne short L11
  SPWY(74,75,85,74)
L11:
  cmp al,11
  jne short L12
  SPWY(74,75,86,74)
L12:
  cmp al,12
  jne short L13
  SPWY(74,75,86,87)
L13:
  cmp al,13
  jne short L14
  SPWY(74,75,86,88)
L14:
  cmp al,14
  jne short L15
  SPWY(74,75,86,89)
L15:
  SPWY(74,75,86,90)
  ret
ENDP DRAWPOWERY

PROC DRAWJOY
  mov eax,5
  call systemdelay
  call calcx
  call drawpowerx
  mov eax,5
  call systemdelay
  call calcy
  call drawpowery
  call systemkeypressed
  je DRAWJOY
  ret
ENDP DRAWjoy

PROC SETALL
  call checkforjoystick
  cmp eax,0
  je Joyerror
  call initgraph
  call FILLBACKGROUND
  mov ecx,30
  mov edx,30
  mov edi,110
  mov esi,260
  mov bl,75
  call fillblock
  mov ecx,20
  mov edx,20
  mov edi,100
  mov esi,250
  mov bl,77
  call fillblock
  mov ecx,90
  mov edx,40
  mov edi,offset mesg1
  mov bl,31
  call outtextxy
  mov ecx,35
  mov edx,60
  mov edi,offset mesg2
  mov bl,0
  call outtextxy
  mov ecx,43
  mov edx,76
  mov edi,offset mesg3
  mov bl,0
  call outtextxy
  call getxaxis
  mov joyminleft,eax
  mov joymaxright,eax
  call getyaxis
  mov joymaxlow,eax
  mov joyminhigh,eax
  call drawjoy
  call settextmode
  exit(0);
JoyError:
  writeln('No Joystick detected...');
  exit(3)
  ret
ENDP SETALL

.DATA
.ALIGN
    graphic_objects             db 100,100,101,101,100,100,101,101
                                db 100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,100,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,100,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,100,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,100,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,100,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,100,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 23, 23, 23, 23, 23, 23, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 23, 23, 23, 23, 23, 23, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,100,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 23, 23, 23, 23, 23, 23, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96,  8,  8,  8,  8,  8,  8, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 23, 23, 23, 23, 23, 23, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,100,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 23, 23, 23, 23, 23, 23, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96,  8,  8,  8,  8,  8,  8, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96,  8,  8,  8,  8,  8,  8, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 23, 23, 23, 23, 23, 23, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,100,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 23, 23, 23, 23, 23, 23, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,100,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,100,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,100,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,100,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 39, 39, 39, 39, 39, 39, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 23, 23, 23, 23, 23, 23, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,100,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 23, 23, 23, 23, 23, 23, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 23, 23, 23, 23, 23, 23, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,100,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 23, 23, 23, 23, 23, 23, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 23, 23, 23, 23, 23, 23, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96,  8,  8,  8,  8,  8,  8, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,100,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 32, 32, 32, 32, 32, 32, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 23, 23, 23, 23, 23, 23, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96, 23, 23, 23, 23, 23, 23, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96,  8,  8,  8,  8,  8,  8, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,100,101,100,100,101,101,100,100,101,101
db 100,100,101,101, 96, 96, 96, 96, 96, 96, 96, 96,100,100,101,101
db 101,101,100,100, 96,  8,  8,  8,  8,  8,  8, 96,101,101,100,100
db 101,101,100,100, 96, 96, 96, 96, 96, 96, 96, 96,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96
db 100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96
db 101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96
db 101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96
db 100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96
db 100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96
db 101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96
db 101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96
db 100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96,100, 96, 39, 96
db 101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96,101, 96, 39, 96
db 101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96,101, 96, 39, 96
db 100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96,100, 96, 39, 96
db 100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96,100, 96, 39, 96
db 101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96,101, 96, 39, 96
db 101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96
db 100, 96, 32, 96,100, 96, 32, 96,100, 96, 39, 96,100, 96, 39, 96
db 101, 96, 32, 96,101, 96, 32, 96,101, 96, 39, 96,101, 96, 39, 96
db 101, 96, 32, 96,101, 96, 32, 96,101, 96, 39, 96,101, 96, 39, 96
db 100, 96, 32, 96,100, 96, 32, 96,100, 96, 39, 96,100, 96, 39, 96
db 100, 96, 32, 96,100, 96, 32, 96,100, 96, 39, 96,100, 96, 39, 96
db 101, 96, 32, 96,101, 96, 32, 96,101, 96, 39, 96,101, 96, 39, 96
db 101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96
db 100, 96, 32, 96,100, 96, 40, 96,100, 96, 39, 96,100, 96, 39, 96
db 101, 96, 32, 96,101, 96, 40, 96,101, 96, 39, 96,101, 96, 39, 96
db 101, 96, 32, 96,101, 96, 40, 96,101, 96, 39, 96,101, 96, 39, 96
db 100, 96, 32, 96,100, 96, 40, 96,100, 96, 39, 96,100, 96, 39, 96
db 100, 96, 32, 96,100, 96, 40, 96,100, 96, 39, 96,100, 96, 39, 96
db 101, 96, 32, 96,101, 96, 40, 96,101, 96, 39, 96,101, 96, 39, 96
db 101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96
db 100, 96, 39, 96,100, 96, 40, 96,100, 96, 39, 96,100, 96, 39, 96
db 101, 96, 39, 96,101, 96, 40, 96,101, 96, 39, 96,101, 96, 39, 96
db 101, 96, 39, 96,101, 96, 40, 96,101, 96, 39, 96,101, 96, 39, 96
db 100, 96, 39, 96,100, 96, 40, 96,100, 96, 39, 96,100, 96, 39, 96
db 100, 96, 39, 96,100, 96, 40, 96,100, 96, 39, 96,100, 96, 39, 96
db 101, 96, 39, 96,101, 96, 40, 96,101, 96, 39, 96,101, 96, 39, 96
db 101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96
db 100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96,100, 96, 23, 96
db 101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96,101, 96, 23, 96
db 101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96,101, 96, 23, 96
db 100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96,100, 96, 23, 96
db 100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96,100, 96, 23, 96
db 101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96,101, 96, 23, 96
db 101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96
db 100, 96, 32, 96,100, 96, 32, 96,100, 96, 55, 96,100, 96, 23, 96
db 101, 96, 32, 96,101, 96, 32, 96,101, 96, 55, 96,101, 96, 23, 96
db 101, 96, 32, 96,101, 96, 32, 96,101, 96, 55, 96,101, 96, 23, 96
db 100, 96, 32, 96,100, 96, 32, 96,100, 96, 55, 96,100, 96, 23, 96
db 100, 96, 32, 96,100, 96, 32, 96,100, 96, 55, 96,100, 96, 23, 96
db 101, 96, 32, 96,101, 96, 32, 96,101, 96, 55, 96,101, 96, 23, 96
db 101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96
db 100, 96, 32, 96,100, 96,  8, 96,100, 96, 55, 96,100, 96, 23, 96
db 101, 96, 32, 96,101, 96,  8, 96,101, 96, 55, 96,101, 96, 23, 96
db 101, 96, 32, 96,101, 96,  8, 96,101, 96, 55, 96,101, 96, 23, 96
db 100, 96, 32, 96,100, 96,  8, 96,100, 96, 55, 96,100, 96, 23, 96
db 100, 96, 32, 96,100, 96,  8, 96,100, 96, 55, 96,100, 96, 23, 96
db 101, 96, 32, 96,101, 96,  8, 96,101, 96, 55, 96,101, 96, 23, 96
db 101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96
db 100, 96,  8, 96,100, 96,  8, 96,100, 96, 55, 96,100, 96, 23, 96
db 101, 96,  8, 96,101, 96,  8, 96,101, 96, 55, 96,101, 96, 23, 96
db 101, 96,  8, 96,101, 96,  8, 96,101, 96, 55, 96,101, 96, 23, 96
db 100, 96,  8, 96,100, 96,  8, 96,100, 96, 55, 96,100, 96, 23, 96
db 100, 96,  8, 96,100, 96,  8, 96,100, 96, 55, 96,100, 96, 23, 96
db 101, 96,  8, 96,101, 96,  8, 96,101, 96, 55, 96,101, 96, 23, 96
db 101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96
db 100, 96, 39, 96,100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96
db 101, 96, 39, 96,101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96
db 101, 96, 39, 96,101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96
db 100, 96, 39, 96,100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96
db 100, 96, 39, 96,100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96
db 101, 96, 39, 96,101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96
db 101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96
db 100, 96, 39, 96,100, 96, 39, 96,100, 96, 32, 96,100, 96, 32, 96
db 101, 96, 39, 96,101, 96, 39, 96,101, 96, 32, 96,101, 96, 32, 96
db 101, 96, 39, 96,101, 96, 39, 96,101, 96, 32, 96,101, 96, 32, 96
db 100, 96, 39, 96,100, 96, 39, 96,100, 96, 32, 96,100, 96, 32, 96
db 100, 96, 39, 96,100, 96, 39, 96,100, 96, 32, 96,100, 96, 32, 96
db 101, 96, 39, 96,101, 96, 39, 96,101, 96, 32, 96,101, 96, 32, 96
db 101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96
db 100, 96, 39, 96,100, 96, 39, 96,100, 96, 39, 96,100, 96, 32, 96
db 101, 96, 39, 96,101, 96, 39, 96,101, 96, 39, 96,101, 96, 32, 96
db 101, 96, 39, 96,101, 96, 39, 96,101, 96, 39, 96,101, 96, 32, 96
db 100, 96, 39, 96,100, 96, 39, 96,100, 96, 39, 96,100, 96, 32, 96
db 100, 96, 39, 96,100, 96, 39, 96,100, 96, 39, 96,100, 96, 32, 96
db 101, 96, 39, 96,101, 96, 39, 96,101, 96, 39, 96,101, 96, 32, 96
db 101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96
db 100, 96, 39, 96,100, 96, 39, 96,100, 96, 39, 96,100, 96, 39, 96
db 101, 96, 39, 96,101, 96, 39, 96,101, 96, 39, 96,101, 96, 39, 96
db 101, 96, 39, 96,101, 96, 39, 96,101, 96, 39, 96,101, 96, 39, 96
db 100, 96, 39, 96,100, 96, 39, 96,100, 96, 39, 96,100, 96, 39, 96
db 100, 96, 39, 96,100, 96, 39, 96,100, 96, 39, 96,100, 96, 39, 96
db 101, 96, 39, 96,101, 96, 39, 96,101, 96, 39, 96,101, 96, 39, 96
db 101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96
db 100, 96, 23, 96,100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96
db 101, 96, 23, 96,101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96
db 101, 96, 23, 96,101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96
db 100, 96, 23, 96,100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96
db 100, 96, 23, 96,100, 96, 32, 96,100, 96, 32, 96,100, 96, 32, 96
db 101, 96, 23, 96,101, 96, 32, 96,101, 96, 32, 96,101, 96, 32, 96
db 101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96
db 100, 96, 23, 96,100, 96, 23, 96,100, 96, 32, 96,100, 96, 32, 96
db 101, 96, 23, 96,101, 96, 23, 96,101, 96, 32, 96,101, 96, 32, 96
db 101, 96, 23, 96,101, 96, 23, 96,101, 96, 32, 96,101, 96, 32, 96
db 100, 96, 23, 96,100, 96, 23, 96,100, 96, 32, 96,100, 96, 32, 96
db 100, 96, 23, 96,100, 96, 23, 96,100, 96, 32, 96,100, 96, 32, 96
db 101, 96, 23, 96,101, 96, 23, 96,101, 96, 32, 96,101, 96, 32, 96
db 101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96
db 100, 96, 23, 96,100, 96, 23, 96,100, 96,  8, 96,100, 96, 32, 96
db 101, 96, 23, 96,101, 96, 23, 96,101, 96,  8, 96,101, 96, 32, 96
db 101, 96, 23, 96,101, 96, 23, 96,101, 96,  8, 96,101, 96, 32, 96
db 100, 96, 23, 96,100, 96, 23, 96,100, 96,  8, 96,100, 96, 32, 96
db 100, 96, 23, 96,100, 96, 23, 96,100, 96,  8, 96,100, 96, 32, 96
db 101, 96, 23, 96,101, 96, 23, 96,101, 96,  8, 96,101, 96, 32, 96
db 101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96,100, 96, 96, 96
db 100, 96, 23, 96,100, 96, 23, 96,100, 96,  8, 96,100, 96,  8, 96
db 101, 96, 23, 96,101, 96, 23, 96,101, 96,  8, 96,101, 96,  8, 96
db 101, 96, 23, 96,101, 96, 23, 96,101, 96,  8, 96,101, 96,  8, 96
db 100, 96, 23, 96,100, 96, 23, 96,100, 96,  8, 96,100, 96,  8, 96
db 100, 96, 23, 96,100, 96, 23, 96,100, 96,  8, 96,100, 96,  8, 96
db 101, 96, 23, 96,101, 96, 23, 96,101, 96,  8, 96,101, 96,  8, 96
db 101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96,101, 96, 96, 96
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 100,100,101,101,100,100,101,101,100,100,101,101,100,100,101,101
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100
db 101,101,100,100,101,101,100,100,101,101,100,100,101,101,100,100

END SETALL