; This program is made by Daniel Horchner.
; email: dbjh@gmx.net
;
; All credits go to Black Phantom (Vadim Drubetsky) for coming up with the
; idea to do this.
; email: vadim@arx.com
;
; If you want to run the PL 0 code under Win9x with IRQs enabled, the stack
; must be large enough. A stack of 200h bytes is enough on my computer.

segment code32 public align=16 use32

%include "raw32.inc"

;32-bit data
LDTdsc          seg_descriptor  0,0,0, 92h, 0,  ; data dsc to access the LDT
LDTsel          dw      0

%macro  gate_dsc 0-5 0,0,0,0,0
  .offset0_15   dw      %1
  .selector     dw      %2
  .count        db      %3
  .access       db      %4
  .offset16_31  dw      %5
%endmacro

enterPL0dsc     gate_dsc        0,0, 0, 8ch, 0  ; dsc type ch=call gate
enterPL0sel     dw      0
code32selPL0    dw      0
data32selPL0    dw      0

ostackptrPL0:                           ; original PL 0 stack registers
oespPL0         dd      0
ossPL0          dw      0
nstackptrPL0:                           ; PL 0 alias of PL 3 ss
nespPL0         dd      0
nssPL0          dw      0

errmsg          db      'An error occurred.','$'
PL0msg          db      'Already running at Privilege Level 0.','$'
excmsg          db      'Can not access Privilege Level 0 under this DPMI '
                db      'server.','$'
msg             db      'Message from Privilege Level 0!',0

oexc13          dd      0
                dw      0

;32-bit code
main:
        cmp byte [systemtype],3
        jne short .PL0
        mov ebx,cs                      ; DPMI, but PL > 0?
        lar ecx,ebx
        and ecx,6000h                   ; Only the DPL bits are needed
        jnz short .notPL0

.PL0:
        mov edx,PL0msg                  ; Not running under DPMI (PL 0) or 
        call dosprint                   ;  running under a PL 0 DPMI server
        jmp exit
.notPL0:
;

        push ds
        pop es
                                        ; Exit elegantly under safer DPMI's
        mov ax,202h                     ; ax=202h -> Get exc handler (PL 3)
        mov bl,13   
        int 31h
        jc near errexit
        mov [oexc13+4],cx
        mov [oexc13],edx
        mov ax,203h                     ; ax=203h -> Set exc handler (PL 3)
        mov cx,cs
        mov edx,toobad
        int 31h
        jc near errexit

        mov ax,0
        mov cx,4
        int 31h
        jc near errexit
        mov [code32selPL0],ax
        add ax,8
        mov [data32selPL0],ax           ; Needed for ss in PL 0 (ss's DPL
        add ax,8                        ;  must be equal to cs's DPL)
        mov [enterPL0sel],ax
        add ax,8             
        mov [LDTsel],ax

        sub esp,6                       ; Create a descriptor to access the
        sgdt [esp]                      ;  LDT conveniently
        mov edi,[esp+2]
        add esp,6
        sldt bx
        and ebx,0fff8h
        add edi,ebx
        mov ax,[gs:edi]
        mov [LDTdsc.limit0_15],ax
        mov ax,[gs:edi+2]
        mov [LDTdsc.base0_15],ax
        mov al,[gs:edi+4]
        mov [LDTdsc.base16_23],al
        mov al,[gs:edi+7]
        mov [LDTdsc.base24_31],al

        mov bx,cs
        lar cx,bx
        and cx,6000h                    ; Only the DPL bits are needed
        or [LDTdsc.access],ch           ; Set the DPL bits to the CPL

        mov edi,LDTdsc
        mov bx,[LDTsel]
        mov ax,0ch
        int 31h
        jc near errexit
                                        ; Create PL 0 alias of cs in LDT
        mov bx,cs
        and bx,~ 7                      ; Clear TI and RPL -> offset in LDT
        mov di,[code32selPL0]
        and di,~ 7
        mov fs,[LDTsel]
        mov eax,[fs:bx]
        mov [fs:di],eax
        mov eax,[fs:bx+4]
        and eax,~ 6000h                 ; Set DPL to 0
        mov [fs:di+4],eax
                                        ; Create PL 0 alias of ss in LDT
        mov bx,ss
        and bx,~ 7
        mov di,[data32selPL0]           ; ss=ds=data32sel at startup
        and di,~ 7
        mov eax,[fs:bx]
        mov [fs:di],eax
        mov eax,[fs:bx+4]
        and eax,~ 6000h
        mov [fs:di+4],eax
                                        ; Create a call gate in the LDT
        mov bx,[code32selPL0]
        mov [enterPL0dsc.selector],bx
        mov word [enterPL0dsc.offset0_15],enterPL0
        or byte [enterPL0dsc.access],3 << 5 ; PL 3 and higher PL code must be
        mov edi,enterPL0dsc             ;  able to call it
        mov bx,[enterPL0sel]
        and bx,~ 7                      ; Clear TI and RPL -> offset in LDT
        mov eax,[edi]
        mov [fs:bx],eax
        mov eax,[edi+4]
        mov [fs:bx+4],eax

        mov bx,[data32selPL0]
        and bx,~ 3                      ; Set RPL to 0 or selector can't be
        mov [nssPL0],bx                 ;  loaded in PL 0 (GPF)
        mov [nespPL0],esp
;       cli                             ; Uncomment for Quarterdeck's DPMI
        call far [enterPL0sel-4]        ; PL 3 -> PL 0

cleanup:                                ; Restore original exception handler
        mov ax,203h
        mov bl,13
        mov cx,[oexc13+4]
        mov edx,[oexc13]
        int 31h
        jc errexit

        jmp exit

errexit:
        mov edx,errmsg
        call dosprint
        jmp exit

;
toobad:                                 ; PL 3 exc 13 handler; called under
        mov edx,excmsg                  ;  safer DPMI's (Linux, WinNT)
        call dosprint
        jmp cleanup

;
enterPL0:                               ; Now running at PL 0!
        mov [ossPL0],ss                 ; Save original PL 0 stack
        mov [oespPL0],esp
        lss esp,[nstackptrPL0]          ; Use same stack in PL 0 as in PL 3
        mov esi,msg
        @rlp edi,0b8000h+160
        mov bl,1fh
        call putstr

        mov ecx,3                       ; Wait 3 seconds
        call delay

        sub esp,6
        sgdt [esp]
        lgdt [esp]                      ; Works only at PL 0
        add esp,6

        lss esp,[ostackptrPL0]          ; Restore original PL 0 stack to
        retf                            ;  return to PL 3

;
delay:                                  ; Bit 4, port 61h toggles every
        in al,61h                       ;  15.085s -> 1 / 15.085s  66291Hz
        and al,10h                      ; Mask bit 4
        mov ah,al
        imul ecx,66291
.checktoggle:
        in al,61h
        and al,10h
        cmp al,ah
        jz .checktoggle                 ; If no change try again
        mov ah,al
        dec ecx
        jnz .checktoggle
        ret
