; This program is made by Daniel Horchner.
; email: dbjh@gmx.net
;
; This program shows 2 features of the 386+ that are connected to switching
; between protected mode and real mode.
; 1.) When switching from protected mode to real mode the invisible part of
;     segment registers stays current. This applies to segments greater than
;     64KB ("flat real mode"), but it applies to segments smaller than 64KB
;     too.
;     The default bit also stays current. So _e_sp is used by stack using
;     instructions when the default bit was set in the stack's descriptor.
;     As long as the segment registers aren't reloaded the base of the
;     protected mode segments stays active in real mode.
; 2.) When switching from real mode to protected mode the base of the segment
;     registers stays current.
;
; Since this program disables paging in order to switch to real mode, it
; could cause a page fault under a VCPI server that maps the linear addresses
; below 1MB not to the same physical addresses (no identity mapping). I
; haven't seen VCPI servers that don't identity map the memory below 1MB, but
; to make this program work under such a VCPI server:
; 1.) call map_phys_addr to map some physical address below 1MB
; 2.) copy the piece of code that must execute in RM to that memory

        .386p
        locals

code32  segment para public use32
        assume cs:code32, ds:code32, ss:code32

include raw32.inc

;32-bit data
toRM            dd      0               ; 32-bit offset
                dw      0               ; selector
oidtr           label   fword
                dw      0,0,0
oint13          dd      0               ; original interrupt 13 vector
ostack          label   fword
oesp            dd      0
oss             dw      0
memptr          dd      0
testvar1        dd      0               ; 11111111h->base of PM ds active
testvar2        dd      0               ; 22222222h->limit of PM ds active
testvar3        dd      0               ; 33333333h->default bit PM ss active
testvar1msg     db      'testvar1(hex)=',0
testvar2msg     db      'testvar2(hex)=',0
testvar3msg     db      'testvar3(hex)=',0
PLmsg           db      'Not running at Privilege Level 0.','$'

;32-bit code
main:
                                        ; First, check if running at PL 0
        mov ebx,cs
        lar ecx,ebx
        and ecx,6000h                   ; Only the DPL bits are needed
        jz short @@PL0
        mov edx,offset PLmsg
        call dosprint
        jmp @exit
@@PL0:
;
        mov ax,code16sel
        mov word ptr toRM[4],ax
        mov toRM[0],large offset RMstart

        mov ebx,offset toPM
        add ebx,code16a
        mov gs:[ebx+2],cs
        mov ax,small offset backinPM
        mov gs:[ebx],ax

        mov eax,64*1024+8               ; Be sure offset is greater than 64K
        call getmem                     ; +8 -> 2 dwords for test variables
        jc @exit
        mov memptr,eax
        add memptr,64*1024              ; testvar2 at memptr

        cli
        sidt oidtr                      ; Save original IDTR
        mov eax,gs:[13*4]               ; Save original interrupt 13 vector
        mov oint13,eax
        mov word ptr gs:[13*4],offset RMexc13
        mov word ptr gs:[13*4+2],code16 ; Install RM exception 13 handler

        push ds es fs gs
        mov oesp,esp
        mov oss,ss

        jmp fword ptr toRM

backinPM:
        lss esp,cs:ostack
        pop gs fs es ds
        mov eax,oint13                  ; Restore original int 13 vector
        mov gs:[13*4],eax
        lidt oidtr                      ; Restore original IDTR
        sti

        mov es,data16sel
        cmp es:exc13,0
        jnz @exit                       ; exception 13 in RM caused exit

        mov edi,memptr
        mov eax,[edi]
        mov testvar2,eax
        mov eax,[edi+4]
        mov testvar3,eax

        mov esi,offset testvar1msg
        mov es,zerosel
        mov edi,0b8000h+160
        mov bl,1fh
        call putstr
        mov eax,testvar1
        call putnum

        mov esi,offset testvar2msg
        mov edi,0b8000h+2*160
        call putstr
        mov eax,testvar2
        call putnum

        mov esi,offset testvar3msg
        mov edi,0b8000h+3*160
        call putstr
        mov eax,testvar3
        call putnum

@exit:
        jmp exit                        ; Return to real/V86 mode

;
; Put number in eax to es:edi in ASCII hexadecimal
; In:
;   eax = number
;   bl = character attribute
; Out:
;   edi = 1 byte past last written character
;
putnum:
        push eax ebx ecx edx
        mov edx,eax
        mov ah,bl
        mov ebx,offset hextbl
        mov ecx,8
@@next_digit:
        rol edx,4
        mov al,dl
        and al,0fh
        xlat
        stosw
        loop @@next_digit
        pop edx ecx ebx eax
        ret

code32  ends

code16  segment para public use16
        assume cs:code16

;16-bit data
ocr0            dd      0               ; Saved CR0 contents
RMidtr          label   fword
                dw      3ffh,0,0
toPM            dw      0               ; 16-bit offset
                dw      0               ; selector
RMexc13msg      db      'Exception 13 in real mode.'
RMexc13msglen   =       $-RMexc13msg
exc13           db      0               ; If non-zero -> exc13 caused exit

;16-bit code
RMstart:
        lidt cs:RMidtr                  ; Necessary so exc 13 calls RMexc13
        mov eax,cr0
        mov gs,cs:data16sel
        mov gs:ocr0,eax
        and eax,7ffffffeh               ; Clear Paging and Protection Enable
        mov cr0,eax
                                        ; in RM with cs still the PM value
        mov testvar1,11111111h          ; ds still has the PM value

        mov ax,0
        mov ds,ax
        mov edi,cs:memptr
        add edi,cs:code32a
        mov ds:[edi],22222222h          ; testvar2=22222222h

        mov edi,100h                    ; At startup es=pspsel (=256 bytes)
;       mov ax,es:[edi]                 ; exception 13

        mov ax,0
        mov ss,ax
        mov esp,cs:memptr               ; At startup ss=data32sel (default=1)
        add esp,4+4                     ; dword value is pushed at esp-4
        add esp,cs:code32a
        push 33333333h                  ; testvar3=33333333h

        db 0eah                         ; JMP intersegment (sets cs) opcode
        dw $+4,code16

        mov eax,cs:ocr0
        mov cr0,eax                     ; in PM while cs has a RM value
        jmp dword ptr cs:toPM           ; Return to 32-bit PM

;
RMexc13:
        db 0eah                         ; Needed on my 386 for "mov cs:...",
        dw $+4,code16                   ;  NOT on my Pentium
        mov cs:exc13,1                  ; Indicate that exc13 has been raised
        mov eax,cs:ocr0
        mov cr0,eax                     ; Restore original CR0 value
                                        ; In PM again
        mov ds,cs:data16sel
        mov si,offset RMexc13msg
        mov es,cs:zerosel
        mov edi,0b8000h+160
        mov cx,RMexc13msglen
        mov ah,1fh
@@putchar:
        lodsb
        stos word ptr es:[edi]
        loop @@putchar
        jmp dword ptr cs:toPM           ; Return to 32-bit PM

code16  ends
        end
