;
; *** Listing 14-15 ***
;
; For comparison with the in-line-code-branched-to-via-a-
; jump-table approach of Listing 14-14, this is a loop-based
; string-search routine that searches at most the specified
; number of bytes of a zero-terminated string for the
; specified character.
;
	jmp	Skip
TestString	label	byte
	db	'This is a string containing the letter '
	db	'z but not containing capital q', 0
;
; Searches a zero-terminated string for a character.
; Searches until a match is found, the terminating zero
; is found, or the specified number of characters have been
; checked.
;
; Input:
;	AL = character to search for
;	BX = maximum # of characters to search
;	DS:SI = string to search
;
; Output:
;	SI = pointer to character, or 0 if character not
;		found
;
; Registers altered: AX, CX, SI
;
; Direction flag cleared
;
; Note: Don't pass a string starting at offset 0, since a
;	match there couldn't be distinguished from a failure
;	to match.
;
SearchNBytes	proc	near
	mov	ah,al		;we'll need AL for LODSB
	mov	cx,bx		;for LOOP
SearchNBytesLoop:
	lodsb
	and	al,al
	jz	NoMatch		;terminating 0, so no match
	cmp	ah,al
	jz	MatchFound	;match, so we're done
	loop	SearchNBytesLoop
;
; No match was found.
;
NoMatch:
	sub	si,si	;return no-match status
	ret
;
; A match was found.
;
MatchFound:
	dec	si		;point back to matching
				; location
	ret
SearchNBytes	endp
;
Skip:
	call	ZTimerOn
	mov	al,'Q'
	mov	bx,20			;search up to the
	mov	si,offset TestString	; first 20 bytes of
	call	SearchNBytes		; TestString for 'Q'
	mov	al,'z'
	mov	bx,80			;search up to the
	mov	si,offset TestString	; first 80 bytes of
	call	SearchNBytes		; TestString for 'z'
	mov	al,'a'
	mov	bx,10			;search up to the
	mov	si,offset TestString	; first 10 bytes of
	call	SearchNBytes		; TestString for 'a'
	call	ZTimerOff
