$CODE SEG "QB2PB"
$COMPILE UNIT
DEFINT A-Z

EXTERNAL Red%(),Green%(),Blue%()
EXTERNAL ColorAttrib%(),SinTable%(),CosTable%()
EXTERNAL VideoAdress???,BufferAdress???
EXTERNAL LprX%,Lpry%,ForeGround%,BackGround%
EXTERNAL Descr???,OrgArrayOff??


SUB PageCopy (FromPage%, ToPage%) STATIC PUBLIC
'************************************************************
IF Start% = 0 then
	DIM VideoBufferSize??(19),Pages%(19)
	restore VBufferSize

	for i% = 0 to 13
		read VideoBuffersize??(i%)
	next i%
	for i% = 0 to 13
	      read Pages%(i%)
	next i%

     INCR Start%
END IF

IF FromPage% = ToPage% THEN EXIT SUB
IF VideoBufferSize??(PbvScrnMode) = 0 then EXIT SUB
P% = Pages%(PbvScrnMode)
IF FromPage% > P% OR ToPage% > P% THEN EXIT SUB


DEF SEG = &H40
IF PbvScrnMode = 0 then
	BufferSize?? = PEEK(&H4C) + PEEK(&H4D) * 256
	SourceAdress??? = Pbvscrnbuff +  FromPage% * BufferSize??
	DestinationAdress??? = Pbvscrnbuff + ToPage% * BufferSize??
	TextCopy SourceAdress???,DestinationAdress???,BufferSize??
      EXIT SUB
ELSE
	BufferSize?? = VideoBufferSize??(PbvScrnMode)
END IF
DEF SEG


DIM VideoBuffer??(BufferSize??-1)
SourceAdress??? = Pbvscrnbuff +  FromPage% * BufferSize??
DestinationAdress??? = Pbvscrnbuff + ToPage% * BufferSize??

FOR plane? = 0 TO 3
    GetPlane  SourceAdress???,BufferSize??,Plane?,VideoBuffer??(0)
    'or z% = 0 to Buffersize??
    'print VideoBuffer??(z%);
    'ext z%

    PutPlane  DestinationAdress???,BufferSize??,Plane?,VideoBuffer??(0)
NEXT plane%

' Reset the ports. (got this from a program by Hans Lunsink)
OUT &H3C4, 2: OUT &H3C5, 16
OUT &H3CE, 4: OUT &H3CF, 0
ERASE VideoBuffer??
END SUB

SUB TextCopy(BYVAL SourceAdress??? ,BYVAL DestinationAdress???,BYVAL BufferSize??) PUBLIC
!    PUSH    DS              ;Save the Destination Segment
!    MOV     CX,BufferSize??
!    LES     DI,DestinationAdress???
!    LDS     SI,SourceAdress???

!db &hC1                                ;  shr     cx,2
!db &hE9
!db 02
!    CLD
' rep movsd
!Db      &hF3                     ; move the data
!Db      &h66
!Db      &hA5
!    POP     DS              ;Reset the Destination Segment
END SUB

SUB GetPlane (BYVAL SourceAdress??? , BYVAL BufferSize??, BYVAL Plane?,ANY ) LOCAL PUBLIC
'Credit to Don Schulian Public Domain GetPlane and PutPlane.

    !      push    ds                   ; save for PowerBASIC
    !      mov     dx,&h03CE            ; set VGA to read
    !      mov     al,4                 ;
    !      out     dx,al                ;
    !      inc     dx                   ;
    !      mov     al,Plane?            ; set the plane to be read
    !      out     dx,al                ;
    !      mov     cx,BufferSize??
    !      les     di,[bp+6]            ; load array to ES:DI
    !      lds     si, SourceAdress???  ; load array to DS:SI

    !db &hC1                                ;  shr     cx,2
    !db &hE9
    !db 02
    !    CLD
' rep movsd
    !Db      &hF3                     ; move the data
    !Db      &h66
    !Db      &hA5
    !      xor     al,0                 ; restore VGA
    !      out     dx,al                ;
    !      pop     ds                   ;

END SUB
'......................................
'                                      
' PURPOSE: Copy data from a scalar array to one plane of the VGA screen
'  PARAMS: ANY       any scalar array of 38400 bytes or more holding the data
'          Plane?    the plane to be written (0, 1, 2, or 3)
'......................................
'                                      
SUB PutPlane ( BYVAL DestinationAdress???, BYVAL BufferSize??, BYVAL Plane?, ANY) LOCAL PUBLIC
'Credit to Don Schulian Public Domain GetPlane and PutPlane.

    !      push    ds                   ; save for PowerBASIC
    !      mov     dx,&h03C4            ; set VGA to write
    !      mov     al,2                 ;
    !      out     dx,al                ;
    !      inc     dx                   ;
    !      dec     al                   ; AL = 1
    !      mov     cl,Plane?            ;
    !      shl     al,cl                ; 1^Plane?
    !      out     dx,al                ;
    !      mov     cx,BufferSize??
    !db &hC1                                ;  shr     cx,2
    !db &hE9
    !db 02
    !      les     di,DestinationAdress??? ; load VGA seg:off  ES:DI
    !      lds     si,[bp+6]            ; load array to DS:SI
    !    CLD
' rep movsd
    !Db      &hF3                     ; move the data
    !Db      &h66
    !Db      &hA5
    !      dec     dx                   ; restore VGA
    !      mov     al,2                 ;
    !      out     dx,al                ;
    !      inc     dx                   ;
    !      mov     al,15                ;
    !      out     dx,al                ;
    !      pop     ds                   ;

END SUB

VBufferSize:
data 1,0,0,0,0,0,0,8192,16384,32768,32768,0,0,0
data 1,0,0,0,0,0,0,7,3,1,1,0,0,0

