char *Copyright = "Copyright 1990, Geneva Switzerland, Markus G. Fischer";

char HELP[] =
"write.com version 1.1, Markus G. Fischer, Oct. 1990\n"
"\n"
"Usage: write <string> \n"
"       Outputs <string> to standard output, without a CR-LF sequence.\n"
"       Meta-strings in the form $c are expanded much like in the `prompt'\n"
"       (the differences are marked with a `*', unknown codes are skipped).\n"
"\n"
"       $  the `$' character                g  the `>' character\n"
"     * t  time up to the seconds           l  the `<' character\n"
"     * d  date without day of the week     b  the `|' character\n"
"       p  current logical directory        q  the `=' character\n"
"     * r  current physical directory       h  the backspace character\n"
"       n  default drive letter             e  the escape character\n"
"     * v  volume label                   * f  the form-feed character\n"
"     * ^c CTRL-c (if '@' <= c <= '_')      _  the CR LF sequence";

/*
 * Written for TurboC 1.5, Markus G. Fischer, January 1989
 * Write *must* be compiled with the tiny memory model, and converted to *.com
 * with EXE2BIN.  It doesn't read parameters through *argv[], but uses the true
 * command line at CS:82 (hex), in order to get the white space correctly...
 *
 * November 1989, version 1.1:
 * removed bug involving a terminal $, cosmetic changes, added $f $^c.
 *
 * October 1990:
 * minor changes, released to the public domain.
 *
 * BUG: $^J sends a CR-LF, not just the LF
 *
 * Do whatever you like with this code, exept selling it, or pretending that
 * you wrote it.  Send comments to "fisher@sc2a.unige.ch".
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <dir.h>

#define COMMAND_LINE MK_FP(_CS,0x82)
#define CTRL(c)      (((toupper(c)&'\xe0')=='\x40')?toupper(c)&'\x1f':(c))
#define putstr(s)    fputs(s,stdout)

char           path[MAXPATH] = "",
               true_path[MAXPATH];
struct country here;


void getpath(void)
/*
 * Stores the current path into `path' and the true path into `true_path'.
 * The true path is obtaind by the dos function call 0x60.
 * DS:SI is input path; ES:DI is output path.
 */
{
	union REGS r;
	struct SREGS s;

	if (*path != '\0')   /* i.e. second call */
		return;
	getcwd (path, MAXPATH);
	r.x.ax = 0x6000;
	/* assuming near pointers: */
	r.x.si = (unsigned)path;
	r.x.di = (unsigned)true_path;
	segread(&s);
	s.es = s.ds;
	intdosx(&r,&r,&s);
}


char *getvolume (void)
/*
 * Finds the volume label of the (physical) current drive.
 * Detects when working on a JOIN'ed, SUBST'ed or network drive, and
 * determines where to look for the volume.
 * The detection of Network drives should be modified to suit other
 * softwares.  Here, it is a path with a leading double-backslash (`\\')
 * that indicates a network drive.
 */
{
	static char volume[12];
	char root[MAXPATH];
	struct ffblk ffblk;
	int len;

	getpath();
	if (*path != *true_path && *true_path != '\\')
	/* i.e. different drive letters */
		if (strlen(true_path) > strlen(path))
		/* i.e. SUBST */
			strncpy (root, true_path, len=3);
		else {
		/* i.e. JOIN */
			strncpy (root, path, len=strlen(path)-strlen(true_path)+3);
			if (root[len-1] != '\\')
				root[len++] = '\\';
			}
	else
	/* i.e. `normal' or network drive */
   	strncpy (root, path, len=3);
	root[len] = '\0';
	strcat (root, "*.*");
	if (!findfirst (root, &ffblk, FA_LABEL)) {
		strncpy (volume, ffblk.ff_name, 8);
		if (strlen(ffblk.ff_name) > 9)
			strncat (volume, &ffblk.ff_name[9], 3);
		}
	else
		strcpy (volume, "(no volume)");
	return (volume);
} /* getvolume() */


void getcountry(void)
{
	int static done = 0;

	if (done)
		return;
	country (0, &here);
	done = 1;
}


void puts_date(void)
{
	struct date today;

	getdate (&today);
	getcountry();
	if (here.co_date == 2)   /* i.e. ASCII date format */
		printf ("%d%s", today.da_year, here.co_dtsep);
	if (here.co_date == 1)   /* i.e. european date format */
		printf ("%02d%s%02d", today.da_day, here.co_dtsep, today.da_mon);
	else                     /* i.e. non-european date format */
		printf ("%02d%s%02d", today.da_mon, here.co_dtsep, today.da_day);
	if (here.co_date != 2)   /* i.e. non-ASCII date format */
		printf ("%s%d", here.co_dtsep, today.da_year);
}


void puts_time(void)
{
	struct time now;

	gettime (&now);
	getcountry();
	printf ("%2d%s%02d%s%02d",
		now.ti_hour, here.co_tmsep, now.ti_min, here.co_tmsep, now.ti_sec);
}


void main (int argc)
{
	char far *command;

	if (argc == 1) {
		puts (HELP);
		exit (1);
		}
	for (command = COMMAND_LINE; *command != '\x0d'; command++) {
		if (*command != '$')
			putchar (*command);
		else {
			switch (tolower(*(++command))) {
				case '$': putchar ('$'); break;
				case 't': puts_time(); break;
				case 'd': puts_date(); break;
				case 'p': getpath(); putstr (path); break;
				case 'r': getpath(); putstr (true_path); break;
				case 'v': putstr (getvolume()); break;
				case 'n': putchar (getdisk()+'A'); break;
				case 'g': putchar ('>'); break;
				case 'l': putchar ('<'); break;
				case 'b': putchar ('|'); break;
				case 'q': putchar ('='); break;
				case 'h': putchar ('\x08'); break;   /* backspace */
				case 'e': putchar ('\x1b'); break;   /* esc */
				case 'f': putchar ('\x0c'); break;   /* form feed */
				case '_': puts (""); break;
				case '^': command++; putchar (CTRL(*command)); break;
				}
			if (*command == '\x0d')
				command--;
			}
		} /* end command line parsing */
	exit(0);
} /* main() */
