/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"

/***
 *  Function    :  strcase
 *
 *  Description :  change case of a string.
 *   		   All special characters are translated (...)
 *
 *  Parameters  :  in   char      *string  string to translate
 *                 in   casetype  type     UPPER/LOWER
 *                                        
 *  Value       :  type = { UPPER, LOWER }
 *
 *  Decisions   :  If character > 255, no change made.
 *
 *  Return      :  pointer to result
 *
 *  OS/Compiler :  All
 ***/

char *strcase( char *string, casetype type )

{ char *ptr;

  for ( ptr = string ; *ptr; ptr++ ) *ptr = chcase( *ptr, type );

  return string;
}

