/*	makefile.c	CI-C86 Utility Function
**
**	Copyright (c) 1985 by:
**
**		Lawrence R. Steeger
**		1009 North Jackson Street
**		Milwaukee, Wisconsin 53202
**		414-277-8149
*/

#include <stdio.h>

/*	makefile(filespec)
**
**	Extract MS-DOS 2 file name from "filespec".
**
**	Returns:	(char *)	file name or EOS
*/

char *makefile(filespec)
unsigned char *filespec;
{
	unsigned char delimit,		/* strrchr() delimiter		*/
		      *pathend,		/* end of drive:path\spec	*/
		      *strrchr();	/* reverse strchr()		*/

	char *alloc(),			/* storage allocator		*/
	     *filename,			/* returned drive:path\name	*/
	     *strncpy();		/* copy string for n characters	*/

	int filelen,			/* length of file name		*/
	    pathlen,			/* length of drive:path\name	*/
	    strlen();			/* get length of string		*/

	/*	determine drive/path delimiting character		*/

	delimit = 0;

	if (strrchr(filespec, '\\') != NULL)
		delimit = '\\';		/* drive:path\ specification	*/

	if (!delimit)
		if (strrchr(filespec, '/') != NULL)
			delimit = '/';	/* drive:path/ specification	*/
		else	delimit = ':';	/* drive: specification		*/

	/*	locate end of drive/path name				*/

	if ((pathend = strrchr(filespec, delimit)) != NULL) {
		pathlen = (pathend - filespec) + 1;
		filelen = strlen(&filespec[pathlen]);
		filename = alloc(strlen(filelen) + 1);
		return (strncpy(filename, &filespec[pathlen], filelen));
	}
	else {				/* no path name			*/
		filename = alloc(strlen(filespec) + 1);
		strcpy(filename, filespec);
		return (filename);
	}
}

/*	end of makefile.c						*/

f