/*         .c                       freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
double f(
double x)
{
 return(       sqrt(x));
}
char  feq[] = " sqrt(x)";
/* -------------------------------------------------------------------------- */
double Df(
double x)
{
 return(  (1.0/2.0) * (1.0/(sqrt(x))) );
}
char Dfeq[] = " (1.0/2.0)*(1.0/(sqrt(x)))";
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */

/* --------------------------------- MAIN ----------------------------------- */
int main(void)
{
double (*Pfunct)     (double x);
double (*PfunctDeriv)(double x);
/*-------------------------------- PROGRAM ---------------------------------- */
 Pfunct      =  f;
 PfunctDeriv = Df;

 clrscrn();
 printf("  f : x-> %s\n\n",feq );
 printf(" Df : x-> %s\n\n",Dfeq);

 printf(" The equation of the tangent is : \n\n\n\n");
 printf("       Df(c) (x-c) + f(c) = 0\n\n");

                         /* plot [xmin:xmax] [ymin:ymax] */
  gplt_TanA    ( 0,      /* xmin  */
                 4,      /* xmax  */
                 0,      /* ymin  */
                 4,      /* ymax  */
               0.2,      /* amin  */
                 3,      /* amax  */
                .2,      /* astep */
               feq,
         (*Pfunct),
         (*PfunctDeriv)
               );

 printf("\n\n To see the result in Gnuplot (gp373w32.exe) :\n\n");
 printf("     * open the file f_Df.plt with Gnuplot.\n");

 printf("\n Press return to continue");
 getchar();

 return 0;
}

