#include <stdio.h>
#include <time.h>
#include <libp.h>

int _baseputc(int c, FILE *stream)
{
	unsigned char rv = (unsigned char) c;
	if (!(stream->flags & _F_BIN) && c == '\n')
		if (_baseputc('\r',stream) == EOF)
			return EOF;
	if (stream->bsize) {
		if (_writebuf(stream)) {
			stream->flags |= _F_ERR;
			return EOF;
		}
		stream->flags |= _F_OUT;
		*stream->curp++ = (char)c;
		stream->level++;
		if (c == '\n' && (stream->flags & _F_LBUF))
			fflush(stream);
		return c;
	}
	else {
		if (_ll_write(stream->fd,&rv,1)) {
			stream->flags |= _F_ERR;
			return EOF;
		}
	}
	return c;
}
int _basegetc(FILE *stream)
{
	unsigned char rv;
	if (stream->bsize) {
		if (_readbuf(stream))
			return EOF;
		if (!(stream->flags & _F_BIN)) {
			if (*stream->curp == '\r') {
				stream->flags |= _F_SKIPLF;
				stream->level--;
				stream->curp++;
				return('\n');
			}
			else 
				if (*stream->curp == '\n' && stream->flags & _F_SKIPLF) {
					stream->level--;
					stream->curp++;
					return(_basegetc(stream));
				}
				else stream->flags &= ~_F_SKIPLF;
		}
		stream->level--;
		return(*stream->curp++);
	}
	else if (stream->hold) {
		rv = stream->hold;
		stream->hold = 0;
	}
	else {
		if (!_ll_read(stream->fd,&rv,1)) {
			stream->flags |= _F_EOF;
			return EOF;
		}
	}
	return(rv);
}
		