#include <windows.h>
#include <dos.h>
#include <dir.h>
#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

int         chdir( const char  *__path )
{
	return _dos_setpwd(__path);
}
int         findfirst( const char  *__path,
                                    struct ffblk  *__ffblk,
                                    int __attrib )
{
	return _dos_findfirst(__path,__attrib | _A_NORMAL,__ffblk);
}
int         findnext( struct ffblk  *__ffblk )
{
	return _dos_findnext(__ffblk);
}
void        fnmerge( char  *__path,
                                    const char  *__drive,
                                    const char  *__dir,
                                    const char  *__name,
                                    const char  *__ext )
{
	char *p;
	if (__drive[0]) {
		__path[0] = __drive[0];
		__path[1] = ':';
		__path[2] = 0;
		p = __path+2;
	}
	if (__dir[0]) {
		if (__dir[0] != '\\')
			*p++ = '\\';
		strcpy(p,__dir);
		p = p + strlen(p);
	}
	strcpy(p,__name);
	p = p + strlen(p);
	if (__ext[0] && __ext[0] != '.')
		*p++ = '.';
	strcpy(p,__ext);
}
int         fnsplit(const char  *__path,
                                    char  *__drive,
                                    char  *__dir,
                                    char  *__name,
                                    char  *__ext )
{
	char buf[256],*p,*q =buf;
	strcpy(buf,__path);
	p = strrchr(buf,'.');
	if (*(p-1) != '.') {
		strcpy(__ext,p);
		*p=0;
	}
	else __ext[0] = 0;

	if (buf[1] == ':') {
		strncpy(__drive,buf,2);
		__drive[2] = 0;
		q += 2;
	}
	else
		__drive[0] = 0;
	
	p = strrchr(buf,'\\');
	if (p) {
		strcpy(__name,p+1);
		*(p+1) = 0;
	}
	else __name[0] = 0;

	strcpy(__dir,q);
	return 0;
}
int         getcurdir( int __drive, char  *__directory )
{
	return _dos_getpwd(__directory,__drive);
}
char  *     getcwd( char  *__buf, int __buflen )
{
	int drv,rv;
	char ibuf[260];
	drv = getdisk();
	rv = _dos_getpwd(ibuf+3,drv+1);
	ibuf[0] = drv + 'A';
	ibuf[1] = ':';
	ibuf[2] = '\\';
	memcpy(__buf,ibuf,__buflen);
	__buf[__buflen-1] = 0;
	return rv;
}
int         getdisk( void )
{
	int drv;
	_dos_getdrive(&drv);
	return drv-1;
}
int         mkdir( const char  *__path )
{
	if (!CreateDirectory(__path,0)) {
		errno = ENOENT;
		return -1;
	}
	return 0;
}
char  *     mktemp( char  *__template )
{
	int len = strlen(__template),i,j,k,l,m;
	char *p;
	if (len < 6) return 0;
	len = len - 6;
	if ((p =strchr(__template,'.')) && p < __template + len)
		return 0;
	strcpy(__template+len,"AA.AAA");
	for (i=0; i < 26; i++) {
		for (j=0; j < 26; j++) {
			for (k=0; k < 26; k++) {
				for (l=0; l < 26; l++) {
					for (m=0; m < 26; m++) {
						if (!fopen(__template,"rb"))
							return __template;
						fclose(__template);
						__template[l+5]++;
					}
					__template[l+5] = 'A';
					__template[l+4]++;
				}
				__template[l+4] = 'A';
				__template[l+3]++;
			}
			__template[l+3] = 'A';
			__template[l+1]++;
		}
		__template[l+1] = 'A';
		__template[l+0]++;
	}
  /* if they waited this long give them a cookie!!! */
	return 0 ;
}
						
int         rmdir( const char  *__path )
{
	if (!RemoveDirectory(__path)) {
		errno = ENOENT;
		return -1;
	}
	return 0;
}
char  *     searchpath( const char  *__file )
{
	static char buf[256];
	char *path = getenv("PATH"),*p=path,*q;
	FILE *t;
	strcpy(buf,__file);
	t = fopen(buf,"rb");
	if (t) {
		fclose(t);
		if (!strchr(buf,'\\')) {
			getcwd(buf,255);
			strcat(buf,"\\");
		}
		else buf[0] = 0;
		strcat(buf,__file);
		return buf;
	}
	else while (*p) {
		q = buf;
		while (*p != ';' && *p)
			*q++=*p++;
		if (*p) p++;
		if (*(q-1) != '\\')
			*q++ = '\\';
		strcpy(q,__file);
		if ((t = fopen(buf,"rb")) != 0) {
			fclose(t);
			return buf;
		}
	}
	return 0;

}
int         setdisk( int __drive )
{
	int nd ;
	return _dos_setdrive(__drive,&nd);
}