/*
      Module name.
        resclok2.c - display clock w/optional timer

-)    Functional description.
         This program will display a clock in the upper right corner
         of the screen and optionally accept a time and DOS command
         as an argument.  At the specified time the command is passed
         to DOS and the TSR is terminated and freed from memory.  The
         command length is limited to 15 characters, so batch files
         should be used to execute more complex command line
         requirments

--)   NOTICE:  Copyright (C) 1988 Essential Software, Inc.
*/
#include "stdio.h"
#include "tsr.h"
#include	"dos.h"

#define  TRUE  1
#define  FALSE 0
#define	SCAN_Q 16	/* scan code of Q key */

#define  ROW   0
#define  COL   65
#define  ATTR  0x70   /* black on white */

/* int 16h unique function we use to see if loaded */
unsigned int myfunc = 0x7272;

int hr,min,sec,hd;
int schr, schm;       /* scheduled time vars */
int  cmdsize;
char cmd[129];
unsigned char stop = 0;

main(argc,argv)
int  argc;
char **argv;
{
   void clock();
   int  add_arg;      /* counter for command line arguments */

   /* process timed command request */
   if(argc > 2) {
      tim_pars(argv[1]);               /* parse the time into schr & schm */

      add_arg = 2;
      while(argc-- > 2) {              /* add all arguments to command line */
         strcat(cmd, argv[add_arg++]);
         strcat(cmd, " ");
      }
      strcat(cmd, "\r\n");             /* cause return at end of command */
   }

   if (tsrloaded(myfunc) == FALSE)
      {
		printf("RESCLOK2  By Essential Software\n");

      if((cmdsize = strlen(cmd)) > 0)      /* verify command and time */
         if(cmdsize <= 15)
            printf("At %02d:%02d Execute %s", schr, schm, cmd);
         else
            printf("Command length exceeds max of 15");

	   inittsr2(CTRL_KEY | ALT_KEY,SCAN_Q, clock, 0, myfunc, SIG);
      }
   else
      {
      printf("RESCLOK2 Already Loaded!\n");
      exit(1);
      }
}


   static int cnt = 99;	   /*	initialize second comparison variable */

void clock()
{
   char curtime[15];          /* buffer to hold time */
   int  loop;
	union REGS regs;				/* register structure for dos call */
	extern int _hotkey_hit;		/* set to 1 if hotkey was hit */

	if(_hotkey_hit){
		if(freetsr() == 1){
         colrprts("Not Loaded Last! - TSR Will Still Be Loaded!",0,7);
			_hotkey_hit = 0;		/* reset hotkey flag */
		}
	}			


	regs.h.ah = 0x2c;		/* get system time with DOS call */
	intdos(&regs,&regs);	
	sec = regs.h.dh;

   /* we'll only update the clock display when sec changes */
   if(cnt != sec) {
      cnt = sec;
		hr = regs.h.ch;
		min = regs.h.cl;

      /* pretty up display with leading and trailing space */
      curtime[0] = ' ';
      strtime(&curtime[1], hr,min,sec,0,9);
      strcat(curtime, " ");

      display(curtime);                /* put the time on the screen */
   }

   /* process command if one was requested */
      if (!stop)
         if(*cmd && hr == schr && min == schm)
            {
            if (freetsr() == 1)           /* free ISR when done */
               {
               stop = 1;
               colrprts("Not Loaded Last! - TSR Will Still Be Loaded!",0,7);
               }
            else
               if(cmdsize <= 15)
                  kybdstuf(cmd);     /* place the command in the keyboard buffer */
               else
                  colrprts("Command Greater Than 15 Characters!", 0xc, 0);

            }
}

/* Interleave atribute and display time */
display(str)
char *str;
{
   register char *curptr;   /* used to steo thru buffer */
   char buf[31];            /* actual buffer to write to screen */


   curptr = buf;

   /* merge char and attribute for screen format */
   while(*str) {
      *curptr++ = *str++;
      *curptr++ = ATTR;
      }

   /* do the actual display */
   memtoscr(10, (ROW * 160) + (COL * 2), buf);
   return;
}

/*
   This function takes the time in HH:MM format and places it into
   two int variables for hour and minute.
*/
tim_pars(str)
char *str;
{
   char *ptr;   /* used to step thru str */

   for(ptr = str; *ptr != ':' && *ptr; ptr++);

   *ptr++ = '\0';                      /* split hour and point to minute */
   schr = atoi(str);
   schm = atoi(ptr);

   return(0);
}


                    
