/* isdigit.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"isdigit.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(isdigit)
#endif

// isdigit
// GIVEN:
//	chr	character to use in comparison.
// RETURNS: (r8)
//	0	if condition false.
//	!0	if condition is true.
// NOTES:
//  only the last byte of chr is used for comparisons.
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(isdigit)
ilibc_64_proc_prologue
ilibc_64_proc_body
ret_val==r8
chr==r32
tmp==r11
	mov tmp=0xFF
	and chr=tmp,chr		// chr&0xFF
	mov ret_val=r0		// ret_val=0;
	cmp.gtu p30,p31='0',chr	// if ('0'>chr)
	(p30) br.cond.spnt Exit	//  goto Exit
	cmp.ltu p30,p31='9',chr	// if ('9'<chr)
	(p30) br.cond.spnt Exit //  goto Exit
Yes:
	add ret_val=ret_val,r0,1	// ++ret_val
Exit:

ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(isdigit)


