/* strcat.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"strcat.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(strcat)
#endif

// strcat() -- Append a string.
//  char * strcat(const char *, const char * const); 
// GIVEN:
//	p_str1		Destination string.
//	p_str2		Source string.
// RETURNS: (r8)
//	p_str1		Pointer to concatenated string.
// NOTES:
//  if p_str1==p_str2, then returns without altering strings.
//  if p_str1 and p_str2 overlap, undefined behavior.
//  no p_str1 overflow checking is done. 
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(strcat)
ilibc_64_proc_prologue
ilibc_64_proc_body
p_str1==r32
p_str2==r33
ret_ptr==r8
tmp==r11
	mov ret_ptr=p_str1
	cmp.eq p30,p31=p_str1,p_str2
	(p30) br.cond.spnt.clr Exit
	// find end of p_str1
Loop1:
	ld1 tmp=[p_str1],1
	cmp.ne p30,p31=tmp,r0
	(p30) br.cond.sptk Loop1
	sub p_str1=p_str1,r0,1	//--p_str1
Loop2:
	ld1 tmp=[p_str2],1
	st1 [p_str1]=tmp,1
	cmp.ne p30,p31=tmp,r0
	(p30) br.cond.sptk Loop2
Exit:
ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(strcat)
