INCLUDE clibc_16.inc

; strlen() -- Get length of string
; size_t fn_call strlen(const char __near * const);
; GIVEN:
;   p_str	near pointer (source) offset from ds
; RETURNS: (int)
;   #		length of p_strg, excluding terminating null

CLIBC_16_CS SEGMENT
strlen PROC FN_CALL C PUBLIC USES di es, p_str:NEAR16 PTR BYTE
	    mov ax, ds
	    mov es, ax

	    mov di, [p_str]	    ; es:di = string pointer
	    xor ax, ax
	    mov cx, ax
	    dec cx

	    repne scas BYTE PTR es:[di]
	    not cx
	    dec cx

	    mov ax, cx

	    ret
strlen ENDP

; __fastcall
; GIVEN:
;   BX		p_str, (source) offset from ds
; RETURNS:
;   AX		length
; size_t __fastcall fn_call strlen(const char __near * const);
@strlen PROC FN_CALL USES cx es di
	    mov di, bx	    ; es:di = string pointer
	    mov ax, ds
	    mov es, ax

	    xor ax, ax
	    mov cx, ax
	    dec cx

	    repne scas BYTE PTR es:[di]
	    not cx
	    dec cx
	    mov ax, cx
	    ret
@strlen ENDP

; strlen_sss() -- Get length of string
; size_t fn_call strlen_sss(const char __near * const);
; GIVEN:
;   p_str	near pointer (source) offset to ss
; RETURNS: (int)
;   #		length of p_strg, excluding terminating null
strlen_sss PROC FN_CALL C PUBLIC USES di es, p_str:NEAR16 PTR BYTE
	    mov ax, ss
	    mov es, ax

	    mov di, [p_str]	    ; es:di = string pointer
	    xor ax, ax
	    mov cx, ax
	    dec cx

	    repne scas BYTE PTR es:[di]
	    not cx
	    dec cx

	    mov ax, cx

	    ret
strlen_sss ENDP

; __fastcall
; GIVEN:
;   BX		p_str, (source) offset from ss
; RETURNS:
;   AX		length
; size_t __fastcall fn_call strlen_sss(const char __near * const);
@strlen_sss PROC FN_CALL USES cx es di
	    mov di, bx	    ; es:di = string pointer
	    mov ax, ss
	    mov es, ax

	    xor ax, ax
	    mov cx, ax
	    dec cx

	    repne scas BYTE PTR es:[di]
	    not cx
	    dec cx
	    mov ax, cx
	    ret
@strlen_sss ENDP

CLIBC_16_CS ENDS
END
