; strcmp
;   AAA=str
;   BBB=005
;   F=0
;   O=0
; str00500.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strcmp:FN_CALL PTR
p_fn_strcmp P_FN_CALL strcmp
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strcmp() -- Compare strings
;int fn_call strcmp(const char __near * const, char __near * const);
; GIVEN:
;   p_str1	near pointer, offset from ds
;   p_str2	near pointer, offset from ds
; RETURNS:
;   <0	if str1 < str2
;   0	if str1 = str2 (identical)
;   >0	if str1 > str2
BEGIN_CODE_SEGMENT <STRING>
strcmp PROC FN_CALL C USES es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ds
	    mov es, ax

	    mov di,[p_str1]	    ;es:di = destination
	    mov si,[p_str2]	    ;ds:si = source

@@loop:     lods BYTE PTR ds:[si]   ;Load str2 char al
	    mov ah, es:[di]	    ;Load str1 char ah
            inc di
	    cmp ah,al		   ;Not equal?
	    jne @@done
	    test al, al
	    jnz @@loop
	    ; equal
	    xor ax, ax
	    jmp @@exit
@@done:
	    jl @@less
	    ; str1 > str2
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    ; str1 < str2
	    xor ax, ax
	    dec ax
@@exit:
	    ret
strcmp ENDP
END_CODE_SEGMENT <STRING>
END
