; strstr_sss
;   AAA=str
;   BBB=007
;   F=0
;   O=1
; str00701.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strstr_sss:FN_CALL PTR
p_fn_strstr_sss P_FN_CALL strstr_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strstr_sss() -- Search p_str1 for substring p_str2
;char __near *	fn_call strstr_sss(const char __near * const, const char __near * const);
; GIVEN:
;   p_str1	near pointer, (dest) offset from ds
;   p_str2	near pointer, (src) offset from ss
; RETURNS: (char *)
;   pointer	near pointer, offset from ds
;		to substring, if found
;		to terminating '\0' if not found
;		to terminating '\0' if strlen(str2) > strlen(str1)
BEGIN_CODE_SEGMENT <STRING>
strstr_sss PROC FN_CALL C USES ds es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

    mov ax, ds
    mov es, ax
    mov bx, ss
    mov ds, ax
    mov si, [p_str1]	; ds:si=p_str1=substring=src
    mov di, [p_str2]	; es:di=p_str2=search string=dest

    cmp ax, bx
    jne @@cont
    cmp si, di
    jne @@cont
    mov ax, di
    jmp @@exit

@@cont:
    ; get bytes in p_str2 (substring, src), includes ending 0
    mov ax, ss
    mov es, ax
    mov di, [p_str2] ; es:di = p_str2
    xor ax, ax
    mov cx, ax
    dec cx
    repne scas BYTE PTR es:[di]
    not cx
    mov bx, cx ;bx = len substring
    ; ax=0000, bx=bytes(p_str2)

    ; get bytes in p_str1 (search string, dest), includes ending 0
    mov ax, ds
    mov es, ax
    mov di, [p_str1] ; es:di = p_str1
    xor ax, ax
    mov cx, ax
    dec cx
    repne scas BYTE PTR es:[di]
    not cx
    dec di
    push di
    xchg cx, bx
    ; ax=0000, bx=bytes(p_str1), cx=bytes(p_str2)
    ; stk=p_st1(ending 0)

    ; check to see if cx==1, empty search string
    cmp cx, 1
    jg @F
    pop ax
    jmp @@exit
@@:
    sub bx, cx	; cmp bx, cx
    jge @F
    ; cannot be, substring longer than search string
    pop ax
    jmp @@exit

@@:
;    sub bx, cx
    inc bx
    ; bx = number of chars in str1 to check
    dec cx
    ; cx = number of bytes in str2 to use when checking (ie without 0)
    mov ax, ss
    mov es, ax
    mov di, [p_str2]	    ;es:di = substring pointer
    mov si, [p_str1]	    ; ds:si = search string pointer
    mov al, es:[di]	; first char of substring
    ; match the first character
@@loop:
    mov ah, [si]	; ds:[si], next char of string
    cmp al, ah
    jne @@notequal
    ; each char is equal, maybe the rest of the chars are also
    ;	ds:[si] points to char in string, that is equal to first char in sub
    ;	cx bytes in substring to use when checking
	push si ; save current pointer into search string
	push cx ; save substring bytes
	repe cmps BYTE PTR ds:[si], es:[di]
	jcxz @F     ; if cx==0, then MAY have found it
	jmp @@notfoundit    ; cx != 0, then did NOT find it
	@@:
	jz @@foundit	    ; if (cx==0) and (last comparison was equal)
@@notfoundit:
	; not found
	    pop cx ; restore old pointer
	    pop si
	    inc si
	    mov di, [p_str2]	; restore pointer to substring
	    mov al, es:[di]	; first char of substring
	    dec bx
	    jz @@done
	    jmp @@loop
@@foundit:
	    ; found the string
	    pop cx ; restore old pointer
	    pop ax ; was push si
	    pop cx ; clear stack
	    jmp @@exit
@@notequal:
    dec bx
    jz @@done
    inc si
    jmp @@loop

@@done:
    pop ax  ; old pointer
@@exit:
    ret
strstr_sss    ENDP
END_CODE_SEGMENT <STRING>
END
