; memmove_dss
;   AAA=str
;   BBB=016
;   F=0
;   O=2
; str01602.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_memmove_dss:FN_CALL PTR
p_fn_memmove_dss P_FN_CALL memmove_dss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;memmove_dss() -- Copy memory block
;void __near * fn_call memmove_dss(void __near * const, void __near * const, const int);
;GIVEN:
;   p_m1	near pointer, (dest) offset from ss
;   p_m2	near pointer, (source) offset from ds
;   num 	bytes to move
;RETURNS: (void __near *)
;   pointer	near pointer, offset from ss (p_m1)
;NOTES:
;   assumes that the pointer segments will never overlap or are equal
;   makes no assumptions concerning DF
;   returns without altering DF
BEGIN_CODE_SEGMENT <STRING>
memmove_dss PROC FN_CALL C USES es si di,
	    p_m1:NEAR16 PTR, p_m2:NEAR16 PTR, num:WORD
	    pushf

	    mov ax, ss
	    mov es, ax

	    mov di, [p_m1]	    ;es:DI = destination
	    mov si, [p_m2]	    ;ds:SI = source
	    mov cx, [num]	    ;CX = count

	    mov ax, ds
	    mov bx, es
	    cmp ax, bx
	    je @@possiblerev
	    jmp @@doit
@@possiblerev:
	    cmp di,si		    ;Make forward moves
	    jb @@normal		   ;normal
	    je @@done
	    ; reverse
	    std
	    add si, cx
	    add di, cx
	    dec si
	    dec di
	    jmp @@doit
@@normal:
	    cld
@@doit:
	    rep movs BYTE PTR es:[di], ds:[si]
	    ; done
@@done:
	    mov ax, [p_m1]
	    popf
	    ret
memmove_dss ENDP
END_CODE_SEGMENT <STRING>
END
