#include "stdafx.h"
#include <stdio.h>
#include "iport.h"      // IPORT header file

// MyMsgCallback - this function is executed each time when data package
//                 arrives. Put your package processing code here.
int MyMsgCallback ( void* Param )
{
    IIpConnection* conn;

    conn = (IIpConnection*) Param;      // get the pointer to IIpConnection

    if ( conn->GetData() )              // if got any input...
        printf ( "%d :: '%s'\r\n",conn->GetID(),conn->GetData() ); // print it

    return NULL;             // This function shouls always return NULL
}

int main(int argc, char* argv[])
{
    IIpService* myhost;

    // Initialize Windows Sockets.
    if ( IP_OPEN() == -1 )
    {
        puts ("error: Can't initialize WinSock.");
        return 0;
    }

    puts("Starting daemon.");

    // Start the daemon
    if ( -1 == BeginService( TRANS_UDP, // TCP/IP daemon
                  10723,                // on port=10723
                  MyMsgCallback,        // call this when package arrives
                  NULL,                 // argument ignored with UDP
                  NULL,                 // argument ignored with UDP
                  &myhost)              // store pointer in iphst
                  )
    {
        puts ( "error: Can't start service." );
        IP_CLOSE ();
        return 0;
    }

    puts("Receiving...\r\n***************\r\n");

    // Wait for any keyboard input
    getchar();

    puts("Finishing...");

    // Delete daemon and stop all it's threads.
    FinishService( myhost );

    // Uninitialize Windows Sockets.
    IP_CLOSE();

    // quit from program
    return 0;
}

