Comment *
Ŀ
Title	 : moves							     
purpose : moves a buffer to the screen 				     
									     
This routine does a block move  avoiding snow on the Ibm color card.	     
It does this by monitering the video status bit at port location 0x3da      
by Jack A. Zucker (jaz) 75766,1336 on jan 25,1986			     

 *

title	buffer moves
name	moves

	assume cs:_text
_text	segment public byte 'code'
	public _moves

_moves	 proc near

	push bp
	mov bp,sp
	push si
	push di
	push es
	push ds

	mov ax,[bp + 4] 	; get source segment
	mov ds,ax		; in ds
	mov si,[bp + 6] 	; get source offset
	mov ax,[bp + 8] 	; get destin segment
	mov es,ax		; in es
	mov di,[bp + 0Ah]	; get destin offset
	mov bx,di		; save destin offset in bx
	mov ax,[bp + 0Ch]	; get number of rows
	mov cx,[bp + 0Eh]	; get number of columns
	cmp [bp+8],0B000h	; Mono?
	jz mono
next:
	mov dx,3dah		; address of 6845 Status register
	push ax
status_low:
	in al,dx		; get vertical retrace status
	ror al,1		; faster than test
	jc status_low		; wait for partially done retrace
	cli			; don't allow any more interrupts
status_high:
	in al,dx		; wait for beginning of new retrace
	ror al,1
	jnc status_high 	; retrace not started

	movsw
	sti			; interrupts allowed now
	pop ax
	dec cx
	or cx,cx
	jnz next
	add bx,160
	mov di,bx
	mov cx,[bp + 0Eh]
	dec ax
	or ax,ax
	jnz next
	jmp exit

mono:
	movsw
	dec cx
	or cx,cx
	jnz mono
	add bx,160
	mov di,bx
	mov cx,[bp + 0Eh]
	dec ax
	or ax,ax
	jnz mono

exit:
	pop ds
	pop es
	pop di
	pop si
	mov sp,bp
	pop  bp
	ret
_moves	endp
_text	ends
	end
