/* Written 1996  Jonathan Paul Griffiths.
 * Converts windows .fon files into JLib format font files.
 * See the file "readme.jon" for detailed terms concerning the jx_font
 * JLib Extension package.
 *
 * NOTES: this code is only intended to run under WATCOM.
 *        it's not my best work,  but its fine for a run-once conversion.
 */
#include <stdio.h>
#include <jlib.h>
#include <graph.h>
#include <conio.h>
#include <jx_font.h>

int isblank(void);
void get_width(int *width,int height);

int main(int argc, char **argv)
{
 int i;
 int f;

 _setvideomode(_MRES256COLOR); 
 if((f=_registerfonts(argv[1]))>0){
    dump(f);
 }
 else{
    printf("ERROR:Font was not registered.\n",i);
 }

 _unregisterfonts();
 _setvideomode(_DEFAULTMODE);

 return(0);
}


void dump(int f)
{
 char buff[10],c[1];
 int i,j,size,last_char,avg_width,pos=0,xs[256],comp_length;
 struct _fontinfo ft;
 UBYTE *inbuff;
 FILE *fp;

 c[1]='\0';sprintf(buff,"n%d",f);_setfont(buff);_getfontinfo(&ft);

 /* open font file */
 if((fp=fopen("out","wb"))== NULL){
    jlib_exit("dump fopen() failed");
 }
 
 /* find last character */
 for(i=32;i<256;i++){ /* from after space to 1st blank */
     c[0]=i;
     _moveto(0,0);_clearscreen(_GCLEARSCREEN);_outgtext(c);
     if(!isblank()){
        last_char=i;
     }
 }

 printf("%d is last char\n",last_char);

 /* write preliminary details */
 fputc(FONT_MAGIC,fp);
 fputc(0,fp);/* nothing in reserved byte */
 fputc(0,fp);/* not color */

 /* calculate space needed to store font */
 if(ft.pixwidth){                          /* not proportional font */
    fputc(0,fp); /* non prop */

    
    size=(ft.pixwidth*ft.pixheight*(last_char-31));
    avg_width=ft.pixwidth;
    
    for(i=32;i<=last_char;i++){            /* fill in char sizes */
        xs[i]=ft.pixwidth;
    }
 }
 else{
    /* proportional - do char by char (slow) */
    fputc(1,fp); /* prop */

    size=avg_width=0;

    for(i=33;i<=last_char;i++){
        int width;

        c[0]=(char)i;
        _moveto(0,0);_clearscreen(_GCLEARSCREEN);_outgtext(c);

        get_width(&width,ft.pixheight);

        xs[i]=width;
        printf("Width of char %d is %d\n",i,width);

        size+=(width*ft.pixheight);
        avg_width+=width;
    }

    avg_width=avg_width/(last_char-31);
    printf("Avg width is %d\n",avg_width);

    xs[32]=avg_width;

    size+=avg_width*ft.pixheight; /* skip space */
 }

 fputc(avg_width,fp);
 fputc(ft.pixheight,fp);

 fputc(ft.pixheight,fp); /* underline at bottom of char */
 fputc(32,fp); /* minimum char */
 fputc(last_char,fp); /* max char */


 comp_length=(size+7)>>3; 

 /* calloc() space for font */
 if((inbuff=calloc(comp_length*sizeof(UBYTE),1))==NULL){ /* size in BYTES */
    printf("calloc size %d\n",comp_length);
    jlib_exit(" calloc() Failed");
 }

 printf("packing..\n");

 /* pack font */
 for(i=32;i<=last_char;i++){
     int x,y;

     c[0]=i;
     _moveto(0,0);_clearscreen(_GCLEARSCREEN);_outgtext(c);

     printf("char %d width %d\n",i,xs[i]);
     fputc(xs[i],fp); /* write width */

     for(y=0;y<ft.pixheight;y++){
         for(x=0;x<xs[i];x++){
            if(_getpixel(x,y)){
               int foo=pos+x;
               inbuff[foo>>3] |= (1 << (foo & 7 )); /* set bit */
            }
         }
         pos+=xs[i];
     }
     printf("pos for char %d is %d\n",i,pos);
 }

 /* write the bit array length */
 printf("len =%d\n",comp_length);
 fputc((UBYTE)(comp_length & 0xff),fp);
 fputc((UBYTE)((comp_length >> 8)  & 0xff),fp);
 fputc((UBYTE)((comp_length >> 16) & 0xff),fp);
 fputc((UBYTE)((comp_length >> 24)  & 0xff),fp);
      
 /* write the bit array */
 for(i=0;i<comp_length;i++){
     fputc(inbuff[i],fp);
 }

 /* done */
 fclose(fp);
}

#define MX_XY 100        /* max x and y of a font letter */

int isblank(void)
{
 int i,j;
 for(i=0;i<MX_XY;i++){
    for(j=0;j<MX_XY;j++){
        if(_getpixel(i,j)){
           printf("non zero\n");
           return 0; /* not blank */
        }
    }
 }
 printf("zero\n");
 return 1; /* is blank */
}

void get_width(int *width,int height)
{
 int i,j,w=0;

 for(i=0;i<=height;i++){
    for(j=0;j<MX_XY;j++){
        if(_getpixel(i,j)){
           printf("1: xy %d %d\n",i,j);
           if(j>w){
              w=j;
           }
        }
    }
 }
 *width=(w+1); /* set width */
}

