/**  lc_time.c ***********************************************************

     Locales' support for DOS / Win31 / Win32.
            Copyright (c) 1995-1997  by Timofei Bondarenko <tim@ipi.ac.ru>

     LC_TIME
 *-----------------------------------------------------------------------*/
#include "config.h"
#ifdef   _Windows
#include <string.h>
#include "win.h"
#endif
#include "_locale.h"

#ifndef   _Windows  /* DOS */

static const char dmy_c [ ] = "%a %d %b %X %Y",
                  uni_c [ ] = "%x %X";
static       char uni_xD[3][9] = { "%m/%d/%y",
                                   "%d/%m/%y",
                                   "%y/%m/%d" },
                  uni_XT[ ] = "%H:%M:%S%p";
#define FIELDidx(x) ((x)*3-1) /* 3 if "%H:%M:%S"; 4 if "%m%/%d%/%y" */
      /* (index-1) of a separator in: -01^34^67---------012^456^89- */
#define AM_PMidx (FIELDidx(2)+3)          /*^__^*/

LC_ID_ _lc_time_(LC_ID_ ccp)
{
 if (ccp == _lcn_C_) _lc_Fmt_ = _lc_Txt_ = 0;
 else
   {
    struct _dos_LC_ dli;
    if (0 > _dos_getLC_(&dli, sizeof(dli), 1, ccp)) return _lcn_BAD_;
    ccp = catLID(dli);
    _lc_Fmt_ = 1;
    _lc_fmt_c_[1] = uni_c;
    if (_lc_Txt_ = dli.codepage == 866 && /* Russian */
                   dli.country == 007) _lc_fmt_c_[1] = dmy_c;
    else switch(dli.country)
           {
         case   1: /* USA */
         case   2: /* Canada Fr. */
         case   4: /* Canada Eng. */
         case  44: /* UK  */
         case  61: /* Eglish Int. */
         case  64: /* New Zealand */
         case 353: /* Ireland */
                 if (dli.date_fmt == 0) _lc_fmt_c_[1] = _lc_fmt_c_[0];
            else if (dli.date_fmt == 1) _lc_fmt_c_[1] = dmy_c;
         default: break;
           }

    if (dli.date_fmt > 2)  dli.date_fmt = 0;
    _lc_fmt_xD[1] = uni_xD[dli.date_fmt];
    uni_xD[dli.date_fmt][FIELDidx(1)] =
    uni_xD[dli.date_fmt][FIELDidx(2)] = dli.date_sep[0] &&
                                        dli.date_sep[0] != '%'
                                      ? dli.date_sep[0] :  '/';
    _lc_fmt_XT[1] = uni_XT;
    if (dli.hours & 1)
      uni_XT[1] = 'H', uni_XT[AM_PMidx] = '\0';
    else
      uni_XT[1] = 'I', uni_XT[AM_PMidx] = '%';
    uni_XT[FIELDidx(1)] =
    uni_XT[FIELDidx(2)] = dli.time_sep[0] &&
                          dli.time_sep[0] != '%'
                        ? dli.time_sep[0] :  ':';
   }
 return ccp;
}

#else   /*_Windows*/

struct NamEntry { const char **dst;
                  const char **def;
                  unsigned   count,
                             ident;
                };

static const char Wfmt[] = "dMyg" /* (g=Era is not allowed) Win date format */
#ifdef    __WIN32__
                               "hHmst" /* Win time format */
#endif
/***********************/;
static const char WtoU[] = "ddaA""mmbB""yyYY""????"
#ifdef    __WIN32__
                           "IIIIHHHHMMMMSSSSpppp"
#endif
/***********************/;
#ifdef    USE_OLENLS
/*LOCALE_SNATIVEDIGITS	Native equivalents to ASCII 0 through 9.*/
#define STRTERM  0
#define GETcfgSTR(lid,id,buf,max)  GetLocaleInfoA(lid,id,buf,max)
#define GETcfgINT(id)              _lc_getLocaleInt(id)
#undef  COMPAT31
#define COMPAT31 0
#else  /*!USE_OLENLS*/
static const char empty[] = "";
#define STRTERM  1
#define GETcfgSTR(lid,id,buf,max)  GetProfileString(_lc_Intl_sect,\
                                                    id,empty,buf,max)
#define GETcfgINT(id)              GetProfileInt(_lc_Intl_sect,id,1)
#ifndef   COMPAT31
#define   COMPAT31 1 /* Can be redefined here: 1 or 0 */
#endif
#if       COMPAT31
#if 0 /* have <olenls.h> */
#include <olenls.h>
#undef  LOCALE_S1159
#undef  LOCALE_S2359
#undef  LOCALE_SSHORTDATE
#undef  LOCALE_SLONGDATE
#undef  LOCALE_ITIME
#undef  LOCALE_ITLZERO
#else /* haven't <olenls.h> */
#define LOCALE_SDAYNAME1         42
#define LOCALE_SDAYNAME7         48
#define LOCALE_SABBREVDAYNAME1   49
#define LOCALE_SABBREVDAYNAME7   55
#define LOCALE_SMONTHNAME1       56
#define LOCALE_SABBREVMONTHNAME1 68
typedef unsigned long LCID;
typedef unsigned long LCTYPE;
#define LOCALE_USER_DEFAULT    1024
#endif
#endif  /*COMPAT31*/
#define LOCALE_S1159       "s1159"
#define LOCALE_S2359       "s2359"
#define LOCALE_SSHORTDATE  "sShortDate"
#define LOCALE_SLONGDATE   "sLongDate"
#define LOCALE_ITIME       "iTime"
#define LOCALE_ITLZERO     "iTLZero"

static const struct NamEntry   main_cpl[] =
      {
       { &_lc_Wday_ [1][0], &_lc_Wday_ [0][0],  7, 260 }
      ,{ &_lc_Month_[1][0], &_lc_Month_[0][0], 12, 276 }
#if    USE_ABBR_NAMES
      ,{ &_lc_WdayS [0],    &_lc_Wday_ [1][0],  7, 267 }
      ,{ &_lc_MonthS[0],    &_lc_Month_[1][0], 12, 288 }
#endif
      };
#define MAIN_CPL_SIZE (sizeof(main_cpl)/sizeof(main_cpl[0]))
#define MAIN_CPL_ABBR 2
#endif /*!USE_OLENLS*/

#if defined(USE_OLENLS) || COMPAT31

static const struct NamEntry olenls_dll[] =
      {
       { &_lc_Wday_ [1][0], &_lc_Wday_ [0][0],  1, LOCALE_SDAYNAME7         }
      ,{ &_lc_Wday_ [1][1], &_lc_Wday_ [0][1],  6, LOCALE_SDAYNAME1         }
      ,{ &_lc_Month_[1][0], &_lc_Month_[0][0], 12, LOCALE_SMONTHNAME1       }
#if    USE_ABBR_NAMES
      ,{ &_lc_WdayS [0],    &_lc_Wday_ [1][0],  1, LOCALE_SABBREVDAYNAME7   }
      ,{ &_lc_WdayS [1],    &_lc_Wday_ [1][1],  6, LOCALE_SABBREVDAYNAME1   }
      ,{ &_lc_MonthS[0],    &_lc_Month_[1][0], 12, LOCALE_SABBREVMONTHNAME1 }
#endif
      };
#define OLENLS_DLL_SIZE (sizeof(olenls_dll)/sizeof(olenls_dll[0]))
#define OLENLS_DLL_ABBR 3
#endif

static void buildTabs (char **buf)
{
 char *sb = *buf;
#ifdef    USE_OLENLS
 const struct NamEntry *elst = olenls_dll;
 int    SizeIdx = OLENLS_DLL_SIZE;
#define AbbrIdx   OLENLS_DLL_ABBR
#else  /*!USE_OLENLS*/
 UINT err_mode = SetErrorMode(SEM_NOOPENFILEERRORBOX|
                              SEM_FAILCRITICALERRORS);
 const struct NamEntry *elst = main_cpl;
 int    SizeIdx = MAIN_CPL_SIZE;
 HINSTANCE lib;
#if       COMPAT31
#if     USE_ABBR_NAMES
 int    AbbrIdx = MAIN_CPL_ABBR;
#endif
 FARPROC GetLocaleInfoP = NULL;

 if (HINSTANCE_ERROR <= (lib = LoadLibrary("ole2nls.dll")))
   if (GetLocaleInfoP = GetProcAddress(lib, "GetLocaleInfoA"))
     {
      elst = olenls_dll;
      SizeIdx = OLENLS_DLL_SIZE;
#if    USE_ABBR_NAMES
      AbbrIdx = OLENLS_DLL_ABBR;
#endif
     }
   else FreeLibrary(lib);
 if (!GetLocaleInfoP)
#else  /*!COMPAT31*/
#define AbbrIdx  MAIN_CPL_ABBR
#endif /*!COMPAT31*/
                        lib = LoadLibrary("main.cpl");
 SetErrorMode(err_mode);
 if (HINSTANCE_ERROR >  lib) { _lc_Txt_ = 0; return; }
#endif /*!USE_OLENLS*/
 _lc_Txt_ = 1;

 while(SizeIdx--)
   {
    unsigned count;
    for(count = 0; count < elst->count; count++)
      {
       int len;
       elst->dst[count] = sb;
       if ((len =
#ifdef    USE_OLENLS
            GetLocaleInfoA(_lc_Intl_lcid,
                                 elst->ident + count,  sb, 24)
#else
#if       COMPAT31
#ifdef   __WINDOWS_386__
            GetLocaleInfoP? (short)_Call16(
            GetLocaleInfoP, "ddpw",
                        (LCID)LOCALE_USER_DEFAULT,
                        (LCTYPE)(elst->ident + count), sb, 24):
#else
            GetLocaleInfoP? ((int WINAPI (*)(LCID, LCTYPE, char FAR*, int))
            GetLocaleInfoP)(LOCALE_USER_DEFAULT,
                                 elst->ident + count,  sb, 24):
#endif /*__WINDOWS_386__*/
#endif /* COMPAT31*/
            (1 + LoadString(lib, elst->ident + count,  sb, 24))
#endif    /* ^ length without '\0' *//*!USE_OLENLS*/
           ) > 1) sb += len; /* if ((len = ... */
#if    USE_ABBR_NAMES
       else if (SizeIdx < AbbrIdx)
         {
          strcpy(sb, elst->def[count]); sb += 4; sb[-1] = '\0';
         }
#endif
       else elst->dst[count] = elst->def[count];
      }
    elst++;
   }
#ifndef   USE_OLENLS
 FreeLibrary(lib);
#undef   AbbrIdx
#endif
 *buf = sb;
}

#ifdef    USE_OLENLS
static int fmt_int(char *fmt,     LCTYPE  entry)
#else
static int fmt_int(char *fmt, const char *entry)
#endif
{
 char buf_[128], *buf, *ft = fmt;

 if (0 < GETcfgSTR(_lc_Intl_lcid, entry, buf = buf_, sizeof(buf_)))
   while(*buf)
     {
      const char *tms;
      int ch;

      if (*buf == '\'')
        while(ch = *ft = *(++buf))
          {
           if (ch == '%') *(++ft) = '%';
           else if ('\'' == ch &&
                    '\'' != *(++buf)) break;
           ft++;
          }
      else if (tms = strchr(Wfmt, ch = *buf))
        {
         int ii = 0;
         while(ch == *(++buf)) if (ii < 3) ii++;
         *ft++ = '%';      /*^ && ^*/
#if     STRFTIME_WIN
         if (!ii) *ft++ = 'O'; /* "O" modifier */
#endif
         *ft++ = WtoU[ii + ((int)(tms - Wfmt) << 2)];
        }
      else if ('%' == (*ft++ = *buf++)) *ft++ = '%';
     }
 if (ft != fmt) *ft = '\0'; /* Don't destroy an old value */
 return (int)(ft - fmt);
}

LC_ID_ _lc_time_(LC_ID_ ccp)
{
 if (ccp == _lcn_C_) _lc_Fmt_ = _lc_Txt_ = 0;
#ifndef   USE_OLENLS
 else if (ccp != _lcn_DEF_) return _lcn_BAD_;
#endif
 else
   {
#if    USE_ABBR_NAMES
    static char sbuf[386]; /* Not checked : 300 ... */
#else
    static char sbuf[256]; /* Not checked : 300 ... */
#endif
    char *buf = sbuf;
    int ii;

#ifdef   USE_OLENLS
    _lc_Intl_lcid = ccp;
    if (_LOCALEINT_BAD == (ii = GETcfgINT(LOCALE_ITIME)))
      return _lcn_BAD_;
    _lc_Fmt_ = ii;
#else
    _lc_Fmt_ = GETcfgINT(LOCALE_ITIME);
#endif
/* _lc_Fmt_ is temporary used as iTime */

    _lc_AmPm_[1][0] = buf;
    if (0 < (ii = GETcfgSTR(ccp, LOCALE_S1159, buf, 10)))
      buf += ii + STRTERM;
    else _lc_AmPm_[1][0] = _lc_AmPm_[0][0];

    _lc_AmPm_[1][1] = buf;
    if (0 < (ii = GETcfgSTR(ccp, LOCALE_S2359, buf, 10)))
      buf += ii + STRTERM;
    else if (_lc_Fmt_) *buf++ = '\0';
    else _lc_AmPm_[1][1] = _lc_AmPm_[0][1];

#ifndef  __WIN32__
    {
     int  gb, gt;
     char tmb[8];

     _lc_fmt_XT[1] = buf;
     *buf++ = '%';
#if      STRFTIME_WIN
     if (!GETcfgINT(LOCALE_ITLZERO)) *buf++ = 'O'; /* format modifier */
#endif /*STRFTIME_WIN*/
     *buf++ = _lc_Fmt_? 'H': 'I';
#ifdef   USE_OLENLS
     if (0 >= GETcfgSTR(ccp, LOCALE_STIME, tmb, sizeof(tmb)))
       tmb[0] = ':', tmb[1] = '\0';
#else
     GetProfileString(_lc_Intl_sect, "sTime", ":", tmb, sizeof(tmb));
#endif
     for(gb = gt = 0; buf[gb] = tmb[gt]; gb++, gt++)
       if (tmb[gt] == '%') buf[++gb] = '%';
     strcpy(buf + gb + 2, buf);
     buf += gb; *buf++ = '%'; *buf++ = 'M';
     buf += gb; *buf++ = '%'; *buf++ = 'S';
     if (!_lc_Fmt_ || ii > 1 - STRTERM)
       {
/*??    if (_lc_Fmt_) _lc_AmPm_[1][0] = _lc_AmPm_[1][1]; */
        *buf++ = ' '; *buf++ = '%'; *buf++ = 'p';
       }
     *buf++ = '\0';
    }
#else  /*__WIN32__*/
    _lc_fmt_XT[1] = buf;
    if (ii = fmt_int(buf, LOCALE_STIMEFORMAT)) buf += ii + 1;
    else _lc_fmt_XT[1] = _lc_fmt_XT[0];
#endif  /*__WIN32__*/

    _lc_fmt_xD[1] = buf;
    if (ii = fmt_int(buf, LOCALE_SSHORTDATE)) buf += ii + 1;
    else _lc_fmt_xD[1] = _lc_fmt_xD[0];

    _lc_fmt_c_[1] = buf;
    if (ii = fmt_int(buf, LOCALE_SLONGDATE))
      {
       strcpy(buf += ii, " %X"); buf += 4;
      }
    else _lc_fmt_c_[1] = _lc_fmt_c_[0];

    buildTabs(&buf); /* if (!_lc_Txt_) return _lcn_BAD_ -- to begin? */
    _lc_Fmt_ = 1;

#ifndef  _LC_WIN
    if (!_lc_Win) AnsiToOemBuff(sbuf, sbuf, (int)(buf - sbuf) - 1);
#elif   !_LC_WIN
                  AnsiToOemBuff(sbuf, sbuf, (int)(buf - sbuf) - 1);
#endif
   }
 return ccp;
}

#endif  /*_Windows*/

/* end of lc_time.c */