/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"
#define mxr 4
#define mxc 4

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
invB(int n)
{
fraction k;

double pbA      [mxr][mxc*TWOCOL];matrix mA      ={mxr,mxc*TWOCOL,&pbA      [0][0]};
double pbkA     [mxr][mxc*TWOCOL];matrix mkA     ={mxr,mxc*TWOCOL,&pbkA     [0][0]};
double pbTrpsA  [mxr][mxc*TWOCOL];matrix mTrpsA  ={mxr,mxc*TWOCOL,&pbTrpsA  [0][0]};
double pbTrpskA [mxr][mxc*TWOCOL];matrix mTrpskA ={mxr,mxc*TWOCOL,&pbTrpskA [0][0]};
double pbk_TrpsA[mxr][mxc*TWOCOL];matrix mk_TrpsA={mxr,mxc*TWOCOL,&pbk_TrpsA[0][0]};

double pbTrpskA_mns_k_TrpsA[mxr][mxc*TWOCOL];
matrix mTrpskA_mns_k_TrpsA={mxr, mxc*TWOCOL,&pbTrpskA_mns_k_TrpsA[0][0]};

                     mA.rows=n;                   mA.cols=n*TWOCOL;
                    mkA.rows=n;                  mkA.cols=n*TWOCOL;
                 mTrpsA.rows=n;               mTrpsA.cols=n*TWOCOL;
                mTrpskA.rows=n;              mTrpskA.cols=n*TWOCOL;
              mk_TrpsA.rows=n;              mk_TrpsA.cols=n*TWOCOL;

      mTrpskA_mns_k_TrpsA.rows=n;      mTrpskA_mns_k_TrpsA.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */

 k.numer = (int)     (randF(9)+1);
 k.denom = 1;

 randmI(&mA,9);

 clrscrn();
 printf(" %6.0f",k.numer);
 printf("                                                  k :\n\n");
 printf("                                                         A :\n");
 printmI(&mA);
 printf("                                                        kA :\n");
 smultmF(k,&mA,&mkA);
 printmI(&mkA);
 printf("                                             transpose(kA) :\n");
 transposeF(&mkA,&mTrpskA);
 printmI(        &mTrpskA);
 getchar();


 clrscrn();
 printf(" %6.0f",k.numer);
 printf("                                                  k :\n\n");
 printf("                                                         A :\n");
 printmI(&mA);
 printf("                                              transpose(A) :\n");
 transposeF(&mA,&mTrpsA);
 printmI(       &mTrpsA);
 printf("                                            k transpose(A) :\n");
 smultmF(k,&mTrpsA,&mk_TrpsA);
 printmI(          &mk_TrpsA);
 getchar();

 clrscrn();
 printf("                                             transpose(kA) :\n");
 printmI(&mTrpskA);
 printf("                                            k transpose(A) :\n");
 printmI(&mk_TrpsA);
 printf("                          transpose(kA) - (k transpose(A)) :\n");
 submF(&mTrpskA,&mk_TrpsA,&mTrpskA_mns_k_TrpsA);
 printmI(&mTrpskA_mns_k_TrpsA);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n          transpose(kA) - (k transpose(A))        ");
  printf("\n          ********************************      \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"trpdi.exe\"                   \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"trpdi.exe 2\" -> mA 2x2         ");
  printf("\n                \"trpdi.exe 3\" -> mA 3x3         ");
  printf("\n                \"trpdi.exe 4\" -> mA 4x4         ");
  printf("\n                                                  ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    i;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n = atoi(argv[1]);

    if( n> mxr){n=mxr;}
    }
  else
    {
    n = (int) fabs(randF(mxr));
    }

    if(n<2){n=2;}

  invB(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

