/* conic01.c                       freeware                    xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* --------------------------------- MAIN ----------------------------------- */
 main()
{
fraction fx;
fraction fy;

double pbpxy[3][2*TWOCOL]=
{
   1,1,   -1,1,
   2,1,   -9,1,
   3,1,   -8,1,
};
matrix mpxy={3,2*TWOCOL,&pbpxy[0][0]};

double pbk[5][6*TWOCOL];matrix m={5,6*TWOCOL,&pbk[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
  printf("\n");
  printf(" Find the coefficients a, b, c, d,  of a circle  \n\n");
  printf("     ax**2 + ay**2 + bx + cy + d  = 0            \n\n");
  printf(" that passes through these three points.         \n\n");

  printf("     x            y \n");
  printmF4(&mpxy);

  printf("\n");
  printf(" Using the given points, we obtain this matrix.\n");
  printf("  (a = 1/1. This is my choice)\n\n");
  printf("  (a)x**2      (a)y**2      (b)x         ");
  printf("(c)y           (d)              \n");
  mofcircle(&mpxy,&m);
  printmF4(      &m);
  getchar();

  printf("The Gauss Jordan process will reduce this matrix to : \n");
  gaussjordanF(&m);
  printmF4(&m);
  getchar();

  clrscrn();
  printmF4(&m);
  printf(" The coefficients a, b, c, d, of the circle are :  \n\n");
  conicresultis(&m);
  getchar();

  clrscrn();
  printf(" The coefficients a, b, c, d, of the circle are :  \n\n");
  conicresultis(&m);

   printf("     x            y   The given point.\n");
   printmF4(&mpxy);
   printf("\n\n");

  printf(" If you have changed the value of x,y.            \n");
  printf(" You must write here, the good value by hand.   \n\n");

fx.numer = 1;fx.denom = 1; fy.numer = -1;fy.denom =1;calculate_circle(&m,fx,fy);
fx.numer = 2;fx.denom = 1; fy.numer = -9;fy.denom =1;calculate_circle(&m,fx,fy);
fx.numer = 3;fx.denom = 1; fy.numer = -8;fy.denom =1;calculate_circle(&m,fx,fy);

  gnpltconicresultis("geom2d.plt",&m);
  gnpltvectrow2d(    "points",     &mpxy);

  printf("\n\n To see the result in Gnuplot (gp373w32.exe) : \n\n");
  printf("  * open the file \"geom2d.plt\" with Gnuplot.  \n");

  printf("\n\n Press return to continue");
  getchar();
}



