/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include <stdio.h>
#include <math.h>
#include "mydefine.h"
#include "mydata.h"
#include "myprint.h"     /* printm printrow printcol                          */
#include "mycopy.h"      /*  copym  copyrow  copycol                          */
#include "myspecm.h"     /* identity, zero matrix                             */
#include "myfmint.h"     /* rownmini divide a row by a integer if possible    */
#include "myelemrowop.h" /* Elementary row operations. swaprow multrow addrow */
#include "myfmop.h"      /* add, multiply two matrices. transpose             */
#include "myfpivot.h"    /* pivotntzero pivotwork                             */
#include "myfdet.h"      /* det, minor, cofactor, mcofactor, adjoint          */
#include "mygauss.h"     /* gauss gaussjordan                                 */
#include "myid.h"        /* gaussjordan(), inverse() with the identity matrix */
#include "myid2.h"       /* gaussjordan(), inverse() with the identity matrix */
#include "myid3.h"       /* gaussjordan(), inverse() with the identity matrix */

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
 main()
{

double pblock[4][4*TWOCOL]=
{
  1,1,  24,1, -26,1,  29,1,
  0,1,   1,1,  25,1,  27,1,
  0,1,   0,1,   1,1,  26,1,
  0,1,   0,1,   0,1,   1,1,
};
matrix m={4,4*TWOCOL,&pblock[0][0]};


double pblockAT [4][4*TWOCOL];  matrix mAT  = {4,4*TWOCOL,&pblockAT [0][0]};
double pblockT  [4][4*TWOCOL];  matrix mT   = {4,4*TWOCOL,&pblockT  [0][0]};

double pblockID [4][4*TWOCOL];  matrix mID  = {4,4*TWOCOL,&pblockID [0][0]};
double pblockIDT[4][4*TWOCOL];  matrix mIDT = {4,4*TWOCOL,&pblockIDT[0][0]};
double pblockID0[4][4*TWOCOL];  matrix mID0 = {4,4*TWOCOL,&pblockID0[0][0]};
double pblockID1[4][4*TWOCOL];  matrix mID1 = {4,4*TWOCOL,&pblockID1[0][0]};
double pblockID2[4][4*TWOCOL];  matrix mID2 = {4,4*TWOCOL,&pblockID2[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
 printf(" The matrix mA \n");
 printmF(&m);
 copymF(&m,&mAT);

idF3a(&mID,&mT,&m,3);copymF(&mID,&mID0);printf("mID0");printmF(&mID0);getchar();
idF3a(&mID,&mT,&m,2);copymF(&mID,&mID1);printf("mID1");printmF(&mID1);getchar();
idF3a(&mID,&mT,&m,1);copymF(&mID,&mID2);printf("mID2");printmF(&mID2);getchar();

 printf("\n mID2 * mID1 : \n");
 multmF(&mID2, &mID1, &mID);
 printmF(&mID );
 getchar();

 printf("\n mID = (mID2 * mID1) * mID0 : \n");
 multmF(&mID,  &mID0, &mIDT);
 printmF(&mIDT );
 getchar();

 copymF(&mAT,&m);
 printf("\n mID * mA : \n");
 multmF(&mIDT,&m,&mT);
 printmF(        &mT);

 printf("\n Press a key to continue");
 getchar();
}



