/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include <stdio.h>
#include <math.h>
#include "mydefine.h"
#include "mydata.h"
#include "myprint.h"     /* printm printrow printcol                          */
#include "mycopy.h"      /*  copym  copyrow  copycol                          */
#include "myspecm.h"     /* identity, zero matrix                             */
#include "myfmint.h"     /* rownmini divide a row by a integer if possible    */
#include "myelemrowop.h" /* Elementary row operations. swaprow multrow addrow */
#include "myfmop.h"      /* add, multiply two matrices. transpose             */
#include "myfpivot.h"    /* pivotntzero pivotwork                             */
#include "myfdet.h"      /* det, minor, cofactor, mcofactor, adjoint          */
#include "mygauss.h"     /* gauss gaussjordan                                 */
#include "myid.h"        /* gaussjordan(), inverse() with the identity matrix */
#include "myid2.h"       /* gaussjordan(), inverse() with the identity matrix */
#include "myid3.h"       /* gaussjordan(), inverse() with the identity matrix */
#include "myid4.h"       /* gaussjordan(), inverse() with the identity matrix */

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
 main()
{

double pblock[4][4*TWOCOL]=
{
 2,1, -1,2, -3,1,  8,1,
 2,3,  3,2,  3,2,  9,1,
 0,1,  2,1, -7,5,  3,2,
-2,3, -1,2,  0,1, -6,3,
};
matrix m={4,4*TWOCOL,&pblock[0][0]};

double pbmAID    [4][8*TWOCOL]; matrix mAID  ={4,8*TWOCOL,&pbmAID    [0][0]};
double pbmAIDT   [4][8*TWOCOL]; matrix mAIDT ={4,8*TWOCOL,&pbmAIDT   [0][0]};

double pbinv     [4][4*TWOCOL]; matrix minv   ={4,4*TWOCOL,&pbinv    [0][0]};

double pblockT   [4][4*TWOCOL]; matrix mT    ={4,4*TWOCOL,&pblockT   [0][0]};
double pblockT2  [4][4*TWOCOL]; matrix mT2   ={4,4*TWOCOL,&pblockT2  [0][0]};
double pblockT3  [4][4*TWOCOL]; matrix mT3   ={4,4*TWOCOL,&pblockT3  [0][0]};

double pblockID  [4][4*TWOCOL]; matrix mID   ={4,4*TWOCOL,&pblockID  [0][0]};
double pblockIDT1[4][4*TWOCOL]; matrix mIDT1 ={4,4*TWOCOL,&pblockIDT1[0][0]};
double pblockIDT2[4][4*TWOCOL]; matrix mIDT2 ={4,4*TWOCOL,&pblockIDT2[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
 copymF(&m,&mT3);

 mid(&mID);
 copymAID (&m,&mID,&mAID);

 printf("\n");
 printf(" The matrix  mA \n");
 printmF3(&m);
 getchar();

 printf("\n");
 printf(" The matrix  mA_ID \n");
 printmF3(&mAID);
 getchar();

 printf(" Find mID (below the pivots) \n");
 idF4(&mID,&mIDT1,&mIDT2,&mT,&mT2,&m);
 printmF(&mID);
 getchar();

 printf("  mID * mA_ID \n");
 multmF(&mID,&mAID,&mAIDT);
 printmF3(&mAIDT);
 getchar();

 multmF(&mID,&mT3,&m);

 printf(" Find mID (above the pivots) \n");
 idF4a(&mID,&mIDT1,&mIDT2,&mT,&mT2,&m);
 printmF(&mID);
 getchar();

 printf("  mID * mA_ID  \n");
 multmF(&mID,&mAIDT,&mAID);
 printmF3(&mAID);
  getchar();

 printf("\n");
 printf("The inverse matrix is : \n");
 copyinv(&mAID, &minv);
 printmF(&minv);
 getchar();

 copymF(&mT3,&m);

 printf("\n mA * minv give \n");
 multmF(&m, &minv,&mIDT1);
 printmF3(         &mIDT1);

 printf("\n Press a key to continue");
 getchar();
}

