/* mycopy.h                     freeware                   xhunga@tiscali.fr  */

/* ------------------------------ FUNCTION -------------------------- mcopy() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
int copymF(
pmatrix mIn,
pmatrix mOut)
{
  int i,j;
  if (mIn->rows != mOut->rows || mIn-> cols != mOut->cols)
    {
     printf("\n copym() error - matrices different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  for (i = 0 ; i < mIn->rows ; i++)
    for ( j = 0; j < mIn->cols ; j++)
      *(mOut->pblock + i *mOut->cols + j) = *(mIn->pblock + i *mIn->cols + j);
  return(0);
}


/* ------------------------------ FUNCTION ------------------------- copyrow() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
int copyrowF(
pmatrix mIn,
    int rowIn,
pmatrix mOut,
    int rowOut)
{
int j;

  if (mIn-> cols != mOut->cols)
    {
     printf("\n copyrow() error - columns different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }

    for ( j = 0; j < mIn->cols ; j++)
            *(mOut->pblock + rowOut *mOut->cols + j) = \
            *(mIn->pblock  + rowIn   *mIn->cols + j);

  return(0);
}

/* ------------------------------ FUNCTION ------------------------ copycol() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
int copycolF(
pmatrix mIn,
    int colIn,
pmatrix mOut,
    int colOut)
{
int i;

  if (mIn-> rows != mOut->rows)
    {
     printf("\n copycol() error - rows different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }

    for ( i = 0; i < mIn->rows ; i++)
      {
            *(mOut->pblock + i *mOut->cols + colOut * 2 )      = \
            *(mIn->pblock  + i *mIn->cols  + colIn  * 2 );
            *(mOut->pblock + i *mOut->cols + colOut * 2 + 1 ) = \
            *(mIn->pblock  + i *mIn->cols  + colIn  * 2 + 1 );
      }
  return(0);
}

/*------------------------------- FUNCTION ----------------------- copymAID() */
/* Debug : printmF(m);  getchar();                                            */
/* -------------------------------------------------------------------------- */
int copymAID (
pmatrix mA,
pmatrix mID,
pmatrix mAID
)
{
int i;
int k;
int j = mA->rows;
/* ------------------------------------------------------------------ copy mA */
    for (k = 0; k < mA->rows ; k++ )
    {
     for (i = 0; i < mA->rows ; i++ )
      {
            *(mAID->pblock + i *mAID->cols + k * 2     ) = \
              *(mA->pblock + i   *mA->cols + k * 2     );
            *(mAID->pblock + i *mAID->cols + k * 2 + 1 ) = \
              *(mA->pblock + i   *mA->cols + k * 2 + 1 );
      }
    }
/* ----------------------------------------------------------------- copy mID */

  mid(mID);
    for (k = 0; k < mA->rows ; k++ )
    {
     for (i = 0; i < mA->rows ; i++ )
      {
            *(mAID->pblock + i *mAID->cols + j * 2     ) = \
             *(mID->pblock + i  *mID->cols + k * 2     );
            *(mAID->pblock + i *mAID->cols + j * 2 + 1 ) = \
             *(mID->pblock + i  *mID->cols + k * 2 + 1 );
      } j++;
    }
}


/*------------------------------- FUNCTION ------------------------ copyinv() */
/* Debug : printmF(m);  getchar();                                            */
/* -------------------------------------------------------------------------- */
void copyinv (
pmatrix mIn,
pmatrix mOut)
{
int i;
int j = mIn->rows;
int k = 0;

    for (k = 0; k < mIn->rows ; k++ )
    {
     for (i = 0; i < mIn->rows ; i++ )
      {
            *(mOut->pblock + i *mOut->cols + k * 2     ) = \
            *(mIn->pblock  + i *mIn->cols  + j * 2     );
            *(mOut->pblock + i *mOut->cols + k * 2 + 1 ) = \
            *(mIn->pblock  + i *mIn->cols  + j * 2 + 1 );
      }j++;
    }
}


