/* swapid01.c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include <stdio.h>
#include <math.h>
#include "mydefine.h"
#include "mydata.h"
#include "myprint.h"     /* printm printrow printcol                          */
#include "mycopy.h"      /*  copym  copyrow  copycol                          */
#include "myspecm.h"     /* identity, zero matrix                             */
#include "myfmint.h"     /* rownmini divide a row by a integer if possible    */
#include "myelemrowop.h" /* Elementary row operations. swaprow multrow addrow */
#include "myfmop.h"      /* add, multiply two matrices. transpose             */
#include "myfpivot.h"    /* pivotntzero pivotwork                             */
#include "myfdet.h"      /* det, minor, cofactor, mcofactor, adjoint          */
#include "mygauss.h"     /* gauss gaussjordan                                 */
#include "myid.h"        /* gaussjordan(), inverse() with the identity matrix */

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
 main()
{
int row1;
int row2;

double pblockA[5][5*TWOCOL]=
{
 0,1,  0,1,  0,1,  0,1,  0,1,
 1,1,  1,1,  1,1,  1,1,  1,1,
 2,1,  2,1,  2,1,  2,1,  2,1,
 3,1,  3,1,  3,1,  3,1,  3,1,
 4,1,  4,1,  4,1,  4,1,  4,1,
};
matrix mA={5,5*TWOCOL,&pblockA[0][0]};

double pbID[5][   5*TWOCOL];
matrix  mID = {5, 5*TWOCOL,&pbID[0][0]};

double pbB[5][   5*TWOCOL];
matrix  mB = {5, 5*TWOCOL,&pbB[0][0]};


/*-------------------------------- PROGRAM ---------------------------------- */

      mid(&mID);
 printf("\n The identity matrix : \n");
 printmF(&mID);
 getchar();

 row1 = 0;
 row2 = 4;

 printf("\n Swap row %d and row %d : \n",row1,row2);
 swaprowF(&mID, row1, row2);
 printf("\n The new identity matrix is now :\n");
 printmF(&mID);
 getchar();

 printf("\n Multiply the identity matrix :\n");
 printmF(&mID);

 printf("\n by mA   \n");
 printmF(&mA );

 printf("\n mID * mA give \n");
 multmF(&mID,&mA,&mB);
 printmF(        &mB);

 printf("\n Press a key to continue");
 getchar();
}






