/* yplnrI.h                     freeware                   xhunga@tiscali.fr  */

/* see   :   vectao.zip                                                       */
/*           vectao.zip   simil5.c                                            */

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void printcolrowvI(
pmatrix m,
int col)
{
  int i;

  for (i = 0 ; i < m->rows ; i++)
    {
     printf("%.0lf",*(m->pblock+i *m->cols+(col*TWOCOL) ));
     if(i<(m->rows-1)){printf(",");}
    }
}


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void printcolrowvF(
pmatrix m,
int col)
{
  int i;

  for (i = 0 ; i < m->rows ; i++)
    {
     printf("%.0lf/%.0lf",*(m->pblock+i *m->cols+ col*TWOCOL   ),
                          *(m->pblock+i *m->cols+(col*TWOCOL)+1));
     if(i<(m->rows-1)){printf(",");}
    }
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* see   :   vectag.zip  ws_VI.c    dpindpVI.c  lnear2VI.c  lnearVI.c         */
/* -------------------------------------------------------------------------- */
void printmvI(
pmatrix mA,
char strings[99])
{
int i;

    for(i=0 ;i<(mA->cols/2) ;i++)
     {
      if((mA->cols/2)==1)
        {
         printf("   %s = [",strings);
         printcolrowvI(mA,i);
         printf("] \n");
        }
    else{
         printf("   %s%d = [",strings,i+1);
         printcolrowvI(mA,i);
         printf("] \n");
        }
     }
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* see   :   vectag.zip                                                       */
/* -------------------------------------------------------------------------- */
void printmvF(
pmatrix mA,
char strings[99])
{
int i;

    for(i=0 ;i<(mA->cols/2) ;i++)
     {
      if((mA->cols/2)==1)
        {
         printf("   %s = [",strings);
         printcolrowvF(mA,i);
         printf("] \n");
        }
    else{
         printf("   %s%d = [",strings,i+1);
         printcolrowvF(mA,i);
         printf("] \n");
        }
     }
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* see   :   vectag.zip                                                       */
/* -------------------------------------------------------------------------- */
void printw_s_vnI(
pmatrix mw_s,
pmatrix mvn)
{
int i;

printf("   ");
for(i=0; i< ((mvn->cols)/2); i++)
 {
     printf(" % +.0lf/%.0lf*[",*(mw_s->pblock+i *mw_s->cols+0),
                               *(mw_s->pblock+i *mw_s->cols+1));
     printcolrowvI(mvn,i);
     printf("]");
 }
  printf(";");
}




