# 
# Microsoft Visuall C++ NMAKE File
#
# Usage: nmake -f msvc.mak [target]
#
# Allowable build targets:
#   all               - build all libraries and executables
#   static            - build the library as a static library
#   dll               - build the library as a DLL
#   test              - build all the test harness targets
#   test_static       - build the static test harness
#   test_dll          - build the dll test harness
#   clean             - clean all the output files
#   clean_static      - remove the static output files
#   clean_dll         - remove the dll output files
#   clean_test        - remove all the output files for all the test targets
#   clean_test_static - remove the test_static output files
#   clean_test_dll    - remove the test_dll output files

CC=cl.exe
CFLAGS=/I..\include /ML /c /O2 /D /nologo /TC /W3

LINK=link
LFLAGS=/NOLOGO /MACHINE:IX86

STATIC_LIB_TARGET=..\lib\numericsc.lib
DLL_TARGET=..\bin\numericsc.dll
DLL_IMPLIB="..\lib\numericsci.lib"
DLL_EXPLIB="..\lib\numericsci.exp"
TEST_STATIC_TARGET="..\bin\test.exe"
TEST_DLL_TARGET="..\bin\testdll.exe"

all : static dll test

static : $(STATIC_LIB_TARGET)

dll : $(DLL_TARGET)

test : test_static test_dll

clean : clean_static clean_dll clean_test

test_static : $(TEST_STATIC_TARGET)

test_dll : $(TEST_DLL_TARGET)

clean_test : clean_test_static clean_test_dll

#
# static library settings
#
STATIC_OBJ_FILES =    \
  ..\tmp\algorthm.obj \
  ..\tmp\contdist.obj \
  ..\tmp\correlat.obj \
  ..\tmp\datamanp.obj \
  ..\tmp\descript.obj \
  ..\tmp\deviate.obj  \
  ..\tmp\discdist.obj \
  ..\tmp\eigensys.obj \
  ..\tmp\integral.obj \
  ..\tmp\interpol.obj \
  ..\tmp\kernels.obj  \
  ..\tmp\linalg.obj   \
  ..\tmp\mathx.obj    \
  ..\tmp\matutils.obj \
  ..\tmp\noncdist.obj \
  ..\tmp\normdist.obj \
  ..\tmp\numerror.obj \
  ..\tmp\rankdist.obj \
  ..\tmp\ranking.obj  \
  ..\tmp\residual.obj \
  ..\tmp\rootfind.obj \
  ..\tmp\sort.obj     \
  ..\tmp\vecutils.obj

$(STATIC_LIB_TARGET) : $(STATIC_OBJ_FILES)
	$(LINK) /LIB $(LFLAGS) /OUT:$@ $(STATIC_OBJ_FILES)

SOURCE_DIR=..\src
STATIC_OBJ_DIR=..\tmp
{$(SOURCE_DIR)}.c{$(STATIC_OBJ_DIR)}.obj:
  $(CC) $(CFLAGS) /Fo$* $<

clean_static :
	-@erase "..\tmp\algorthm.obj"
	-@erase "..\tmp\contdist.obj"
	-@erase "..\tmp\correlat.obj"
	-@erase "..\tmp\datamanp.obj"
	-@erase "..\tmp\descript.obj"
	-@erase "..\tmp\deviate.obj"
	-@erase "..\tmp\discdist.obj"
	-@erase "..\tmp\eigensys.obj"
	-@erase "..\tmp\integral.obj"
	-@erase "..\tmp\interpol.obj"
	-@erase "..\tmp\kernels.obj"
	-@erase "..\tmp\linalg.obj"
	-@erase "..\tmp\mathx.obj"
	-@erase "..\tmp\matutils.obj"
	-@erase "..\tmp\noncdist.obj"
	-@erase "..\tmp\normdist.obj"
	-@erase "..\tmp\numerror.obj"
	-@erase "..\tmp\rankdist.obj"
	-@erase "..\tmp\ranking.obj"
	-@erase "..\tmp\residual.obj"
	-@erase "..\tmp\rootfind.obj"
	-@erase "..\tmp\sort.obj"
	-@erase "..\tmp\vecutils.obj"
	-@erase $(STATIC_LIB_TARGET)

#
# DLL settings
#
DLL_OBJ_FILES =           \
  ..\tmp\dll\algorthm.obj \
  ..\tmp\dll\contdist.obj \
  ..\tmp\dll\correlat.obj \
  ..\tmp\dll\datamanp.obj \
  ..\tmp\dll\descript.obj \
  ..\tmp\dll\deviate.obj  \
  ..\tmp\dll\discdist.obj \
  ..\tmp\dll\eigensys.obj \
  ..\tmp\dll\integral.obj \
  ..\tmp\dll\interpol.obj \
  ..\tmp\dll\kernels.obj  \
  ..\tmp\dll\linalg.obj   \
  ..\tmp\dll\mathx.obj    \
  ..\tmp\dll\matutils.obj \
  ..\tmp\dll\noncdist.obj \
  ..\tmp\dll\normdist.obj \
  ..\tmp\dll\numerror.obj \
  ..\tmp\dll\rankdist.obj \
  ..\tmp\dll\ranking.obj  \
  ..\tmp\dll\residual.obj \
  ..\tmp\dll\rootfind.obj \
  ..\tmp\dll\sort.obj     \
  ..\tmp\dll\vecutils.obj

$(DLL_TARGET) : $(DLL_OBJ_FILES)
	$(LINK) /DLL $(LFLAGS) /OUT:$(DLL_TARGET) /IMPLIB:$(DLL_IMPLIB) $(DLL_OBJ_FILES)

DLL_OBJ_DIR=..\tmp\dll
{$(SOURCE_DIR)}.c{$(DLL_OBJ_DIR)}.obj:
	$(CC) $(CFLAGS) /D "NUMERICS_SHARED_LIB" /Fo$* $<

clean_dll :
	-@erase "..\tmp\dll\algorthm.obj"
	-@erase "..\tmp\dll\contdist.obj"
	-@erase "..\tmp\dll\correlat.obj"
	-@erase "..\tmp\dll\datamanp.obj"
	-@erase "..\tmp\dll\descript.obj"
	-@erase "..\tmp\dll\deviate.obj"
	-@erase "..\tmp\dll\discdist.obj"
	-@erase "..\tmp\dll\eigensys.obj"
	-@erase "..\tmp\dll\integral.obj"
	-@erase "..\tmp\dll\interpol.obj"
	-@erase "..\tmp\dll\kernels.obj"
	-@erase "..\tmp\dll\linalg.obj"
	-@erase "..\tmp\dll\mathx.obj"
	-@erase "..\tmp\dll\matutils.obj"
	-@erase "..\tmp\dll\noncdist.obj"
	-@erase "..\tmp\dll\normdist.obj"
	-@erase "..\tmp\dll\numerror.obj"
	-@erase "..\tmp\dll\rankdist.obj"
	-@erase "..\tmp\dll\ranking.obj"
	-@erase "..\tmp\dll\residual.obj"
	-@erase "..\tmp\dll\rootfind.obj"
	-@erase "..\tmp\dll\sort.obj"
	-@erase "..\tmp\dll\vecutils.obj"
	-@erase $(DLL_TARGET)
	-@erase $(DLL_IMPLIB)
	-@erase $(DLL_EXPLIB)

#
# Test static settings
#
TEST_STATIC_OBJ_FILES = \
  ..\tmp\test\test.obj

$(TEST_STATIC_TARGET) : $(TEST_STATIC_OBJ_FILES) $(STATIC_LIB_TARGET)
	$(LINK) $(LFLAGS) /OUT:$(TEST_STATIC_TARGET) $(TEST_STATIC_OBJ_FILES) $(STATIC_LIB_TARGET)

TEST_STATIC_SOURCE_DIR=..\test
TEST_STATIC_OBJ_DIR=..\tmp\test
{$(TEST_STATIC_SOURCE_DIR)}.c{$(TEST_STATIC_OBJ_DIR)}.obj:
	$(CC) $(CFLAGS) /D "NUMERICS_SHARED_LIB" /Fo$* $<

clean_test_static :
	-@erase "..\tmp\test\test.obj"
	-@erase $(TEST_STATIC_TARGET)

#
# Test dll settings
#
TEST_DLL_OBJ_FILES =       \
  ..\tmp\dll\test\test.obj

$(TEST_DLL_TARGET) : $(TEST_DLL_OBJ_FILES) $(DLL_TARGET) $(DLL_IMPLIB)
	$(LINK) $(LFLAGS) /OUT:$(TEST_DLL_TARGET) $(TEST_DLL_OBJ_FILES) $(DLL_IMPLIB)

TEST_DLL_SOURCE_DIR=..\test
TEST_DLL_OBJ_DIR=..\tmp\dll\test
{$(TEST_DLL_SOURCE_DIR)}.c{$(TEST_DLL_OBJ_DIR)}.obj:
	$(CC) $(CFLAGS) /D "NUMERICS_SHARED_LIB" /Fo$* $<

clean_test_dll :
	-@erase "..\tmp\dll\test\test.obj"
	-@erase $(TEST_DLL_TARGET)
