/**********************************************************/
/* File Id.                  Attr.C                       */
/* Author.                   Stan Milam.                  */
/* Date Written.             06/03/89.                    */
/*                                                        */
/*         (c) Copyright 1989, 1990 by Stan Milam         */
/*                                                        */
/* Comments: Routines to get the color attributes & char- */
/* acters at a specified row & column in the logical video*/
/* page.                                                  */
/**********************************************************/

#include <dos.h>
#include "pcwproto.h"
#ifdef MSC
#   include <conio.h>
#endif

static void sync_wait(void);
extern int  CheckSnow;

int getattr(int row, int col) {

   int mxr, mxc;
   unsigned  scrnseg;
   int far *scrnptr;
   int page, pagesize, offset;

   if (!chk_video_state(&mxr,&mxc)) return -1;
   page     = getpage();
   scrnseg  = getscrnseg();
   pagesize = getpagesize();
   offset   = MK_SCRNOFF(row,col);
   scrnptr  = (int far *) MK_FP(scrnseg,offset);
   if (CheckSnow) sync_wait();
   return((*scrnptr & 0xff00) >> 8);
}

int getchr(int row, int col) {

   int mxr, mxc;
   unsigned  scrnseg;
   int far *scrnptr;
   int page, pagesize, offset;

   if (!chk_video_state(&mxr,&mxc)) return -1;
   page     = getpage();
   scrnseg  = getscrnseg();
   pagesize = getpagesize();
   offset   = MK_SCRNOFF(row,col);
   scrnptr  = (int far *) MK_FP(scrnseg,offset);
   if (CheckSnow) sync_wait();
   return(*scrnptr & 0x00ff);
}


static void sync_wait(void) {

   while((inportb(0x3da) & 0x8) != 0);
   while((inportb(0x3da) & 0x8) == 0);
}



