QDLL_SIG equ 04C4C4451h      ; "QDLL"      ; the magic number
NAMELEN  equ 64              ; DLL strings are generally 64bytes long
externdef dll_main:near

; various bit flags
QF_COMPRESSED EQU 1          ; if set, the DLL image is compressed
QF_NEWFIXUP   EQU 2          ; new-style fixups

hnds struct  ;DLL handle format
  leimg dd ?      ;LE-EXE image
  lesiz dd ?      ;LE-EXE size (in bytes) ; hm, is this needed?
  exportlst dd ?  ;Export List
    ;dd ? - "Name"
    ;dd ? - addr
  exportsiz dd ?  ;Export size (# of elements)
; need a name dd ? and handling
hnds ends

dllhdrs struct ;QDLL file header
  sig            dd ?     ; "QDLL"
  version        dd ?     ; which version of QDLLFIX produced this QDLL
  imagesize      dd ?     ; size of the DLL exe image
  compressedsize dd ?     ; size of compressed DLL
  bsssize        dd ?     ; size of uninitialized data
  numrelocs      dd ?     ; size of the relocation info (in bytes)
  flags          dd ?     ; QF_* flags (upper two bytes=compression stuff)
  entrypoint     dd ?     ; entrypoint relative to header
  idstring db NAMELEN dup (?)  ; DLL "info" string. Can be anything.
  ; directly after this header follows the binary DLL image,
  ; and after the image comes the relocation info
dllhdrs ends

; The following two macros should be used for generating the
; dll jumptable and pointertable which lets your DLL use functions
; and data from your main program. See "/qlib/inc/src/dlltab.inc"
; to see how it's done. Pretty darn simple, I'd say :-)

;  Oh yeah, the jumptable used to be "safe" even when it wasn't initialized.
;  (Like, functions pointing to NULLPROC). But to improve compression effiency,
;  everything has been zeroed out for the DLL version (the main-program version
;  has everything though, since it's gonna pass it to your DLL). Just don't
;  call library functions from a DLL before the tables have been initialized.

dll_gencode macro s1:REQ
ifdef _DLL_CODE_
  public &s1&           ; this is DLL code, generate functions (labels)
  &s1&:
  dw ?                  ; will be FFh,25h when filled out
  dd ?                  ; will be "$+4", pointing to the next 4 bytes.
  dd ?                  ; will hold the offset of the original function
else
  dw 25FFh              ; jmp [_offset]
  dd $+4                ; here's _offset
  dd offset s1          ; export offset of the func
endif
endm

dll_gendata macro s1:REQ
ifdef _DLL_CODE_
  public __&s1&         ; make it public so it can be referenced
  __&s1& dd ?           ; will be initialized by the DLL startup code
else
  dd offset s1          ; dump the offset of the variable directly
endif
endm