;LE loader for Watcom (c)1996, 1997 M. Tippach
;this variant is inteded to be converted into a binary
;Entered with the file handle in bx and the file pointer of the excutable
;pointing to the start of the LE image

; Modified for QDEBUG by Peter Quiring

include leheader.inc

; globals

.data
align 4
pspsel dw ?
handle dw ?   ;file handle
exeimagesize dd ?
headerimagesize dd ?
leimageoffset dd ?
counter dd ?

exe_off dd ?
exe_hnd dd ?

header_off dd ?
header_hnd dd ?
header_size dd ?

EXE EXEs <>

femsg  db 'Error reading executable',0dh,0ah,'$'
fomsg  db 'Wrong executable format',0dh,0ah,'$'
memsg  db 'Not enough extended memory',0dh,0ah,'$'
dpmimsg db 'DPMI error',0dh,0ah,'$'
cntmsg db 'Counter error',0dh,0ah,'$'
.code

;_debug_ equ 0

debugmsg macro a1
  local b1
  ifdef _debug_
  .data
    b1 db a1,'$'
  .code
    pushad
    mov edx,offset b1
    mov ah,9
    int 21h
    popad
  endif
endm

debugmsg2 macro a1
  local b1
  ifdef _debug_
  .data
    b1 dd ?
       db '$'
  .code
    pushad
    mov b1,a1
    mov edx,offset b1
    mov ah,9
    int 21h
    popad
  endif
endm

file_error:
  mov edx,offset femsg
  jmp short errormsg
format_error:
  mov edx,offset fomsg
  jmp short errormsg
dpmi_error:
  mov edx,offset dpmimsg
  jmp short errormsg
cnt_error:
  mov edx,offset dpmimsg
  jmp short errormsg
mem_error:
  mov edx,offset memsg

errormsg:
  mov ah,9
  int 21h
  mov ax,4cffh
  int 21h

le_loader proc
;input edx=filename

;-------------- save PSP selector ---------------------

  mov pspsel,es

;-------------- enable virtual interrupts -------------

  mov ax,0901h
  int 31h

;------------ open file and lseek() to LE signature ---

  mov ax,3d00h  ;open file (read only)
  xor cx,cx
  ; DS:EDX = filename
  int 21h
  jc file_error
  mov handle,ax

  mov ah,3fh
  mov ecx,sizeof EXE
  mov edx,offset EXE
  mov bx,handle
  int 21h
  jc file_error
  cmp eax,ecx
  jne file_error

;  offset=(EXE.siz2-1)*512;
;  t1=(EXE.siz1 + 0x7) & 0xfff8;
;  offset+=t1;
;  lseek(h,offset,SEEK_SET);

  xor eax,eax
  mov ax,EXE.siz2
  dec eax
  imul eax,512
  mov edx,eax
  xor eax,eax
  mov ax,EXE.siz1
  add eax,07h
  and eax,0fff8h
  add edx,eax

  mov leimageoffset,edx

  debugmsg '1'

  shld ecx,edx,16
  mov ax,4200h  ;SEEK_SET
  mov bx,handle
  int 21h
  jc file_error

  push ds
  pop es

;-------------- alloc all memory ----------------------

  debugmsg '2'

  mov ax,500h
  sub esp,30h
  mov edi,esp
  int 31h
  jc mem_error

  mov edx,dword ptr[esp]   ;get xms memory available
  add esp,30h
tryagain:
  mov ecx,edx
  mov ebx,ecx
  shr ebx,16
  mov ax,501h
  int 31h
  .if carry?
    .if edx < 128 * 1024
      jmp mem_error
    .endif
    sub edx,64*1024
    jmp tryagain
  .endif
  shl ebx,16
  mov bx,cx
  shl esi,16
  mov si,di
  mov header_size,edx
  mov header_off,ebx
  mov header_hnd,esi  ;save later for resize
  mov ebp,ebx

;-------------- read LE header ------------------------

  debugmsg '3'

  mov ecx,sizeof LEHeader
  mov ah,3fh
  mov edx,ebp
  mov bx,handle
  int 21h
  jc file_error
  cmp eax,ecx
  jne file_error

  debugmsg '4'

  mov eax,dword ptr [edx]
  cmp eax,'EL'    ;'LE'
  jnz file_error

;---- calculate total header size needed --------------

  mov eax,LEObjectTable[ebp]  ;size of LE header
  add eax,LELoaderSize[ebp]   ;size of loader data
  ;eax = size of Header image
  mov headerimagesize,eax
  .if eax > header_size
    jmp mem_error
  .endif

;--- realloc RAM for header ----------------------------

  debugmsg '5'

  mov ecx,headerimagesize
  mov ebx,ecx
  shr ebx,16   ;BX:CX = new size
  mov edi,header_hnd
  mov esi,edi
  shr esi,16   ;SI:DI = old handle
  mov ax,503h
  int 31h
  jc mem_error
  shl esi,16
  mov si,di    ;ESI = new handle
  mov header_hnd,esi
  shl ebx,16
  mov bx,cx
  mov header_off,ebx  ;EBX = new offset
  mov ebp,ebx

;------------- load resident header data --------------

  debugmsg '7'

  mov ecx,headerimagesize
  sub ecx,sizeof LEHeader
  lea edx,[ebp+sizeof LEHeader]
  mov ah,3fh
  mov bx,handle
  int 21h
  jc file_error
  cmp eax,ecx
  jne file_error

;------------- calculate overall mem from LE header ---

 ; int 3 ;catch SICE

  mov esi,LEObjectTable[ebp]
  mov eax,LEObjectEntries[ebp]
  xor edx,edx
@@:
  mov ecx,[ebp+esi]
  add esi,24
  add ecx,4095
  and ecx,NOT 4095
  add edx,ecx
  dec eax
  jnz @b

  ;edx = size of EXE image (including stack and BSS stuff)
  mov exeimagesize,edx

;--- alloc RAM for exe image ----------------------------

  debugmsg '6'

  mov ax,501h
  mov ebx,exeimagesize
  mov ecx,ebx
  shr ebx,16
  int 31h
  jc mem_error
  shl esi,16
  mov si,di           ;ESI = new handle
  mov exe_hnd,esi
  shl ebx,16
  mov bx,cx
  mov exe_off,ebx     ;EBX = new offset

;--- zero out the memory ------------------------------

  xor eax,eax
  mov edi,exe_off
  mov ecx,exeimagesize
  shr ecx,2  ;dwords
  rep stosd

;--- move to start of program data --------------------

  mov edx,headerimagesize
  add edx,leimageoffset
  add edx,511
  and edx,0ffffffffh - 511
  shld ecx,edx,16
  mov ax,4200h  ;SEEK_SET
  mov bx,handle
  int 21h
  jc file_error

;------------- start processing Objects --------------

 ; int 3 ;catch SICE

  mov eax,LENumberPages[ebp]
  inc eax
  mov counter,eax

  mov edi,LEObjectEntries[ebp]    ;# objects to load
  mov esi,LEObjectTable[ebp]      ;offset of objects table
  mov edx,exe_off                 ;offset to load objects to

LoadObject:

  mov ebx,OTPageMapSize[ebp+esi]
  mov eax,OTPageMapIndex[ebp+esi]
  shl eax,2
  add eax,LEObjectPMTable[ebp]

; Use reserved field to store actual object load address

  mov OTReserved[ebp+esi],edx  
  mov ecx,LEPageSize[ebp]

  test ebx,ebx
  jz ebxwaszero
ReadPage:

;check against Object Page Table (load or relocation only)
  
  cmp byte ptr [eax+ebp-1],0
  jnz AfterRead

  push eax
  push ebx

  mov bx,handle
  mov ah,3fh
  int 21h
  jc file_error
;  cmp eax,ecx
;  jne file_error   ;last page is small

  pop ebx
  pop eax

AfterRead:
  add edx,ecx
  add eax,4
  dec counter
  jz cnt_error
  dec ebx
  jnz ReadPage
ebxwaszero:
  add esi,24
  dec edi
  jnz LoadObject

  mov ah,3eh  ;close file
  mov bx,handle
  int 21h

;-------------- raw data loaded, now do fixups ----

; considering that there are LOTS of fixups, this could take some time.
; A decent level of speed optimization doesn't hurt... -> 2DO

  mov esi,LEObjectTable[ebp]
  mov edi,LEFixupPageTab[ebp]
  xor edx,edx
  mov ecx,LEFixupRecords[ebp]
  add ecx,ebp

FixupPage:
  mov ebx,[edi+ebp]
  cmp ebx,[edi+ebp+4]
  jnc FixupDone

FixupRecord:

  ; sort of an inner loop [ebx+ecx] = start of fixup record

  cmp byte ptr FRType[ebx+ecx+1],10h
  jnz check16bit

;-------------- 32 bit target ------------------------

  push edi
  movzx edi,FRObject[ecx+ebx]
  mov eax,dword ptr FRItem[ecx+ebx]
  lea edi,[edi*2+edi-3]
  lea edi,[edi*8+esi]      ; edi = (edi*3-3)*8 + esi
  cmp word ptr FRType[ebx+ecx],1002h
  jnz FuNoSel32
  test OTObjectFlags[edi+ebp],4 ;executable?
  movsx edi,FROffset[ecx+ebx]   ;can be negative!
  push edx
  pushfd
  add edx,exe_off
  mov word ptr [edi+edx],ds
  popfd
  jz IsdataSel32
  mov word ptr [edi+edx],cs
IsdataSel32:
  pop edx
  pop edi
  add ebx,7
  cmp ebx,[edi+ebp+4]
  jc FixupRecord
  jmp FixupDone
FuNoSel32:
  add eax,OTReserved[edi+ebp]  
  push edi
  movsx edi,FROffset[ecx+ebx] ;can be negative!
  push edx
  cmp word ptr FRType[ebx+ecx],1008h
  jnz NoRel32
  sub eax,edx
  sub eax,edi
  sub eax,4
NoRel32:
  add edx,exe_off
  mov [edi+edx],ax
  cmp word ptr FRType[ebx+ecx],1005h
  jz Fu32_16
  mov [edi+edx],eax
Fu32_16:
  pop edx
  pop edi
;2do:
  cmp word ptr FRType[ebx+ecx],1007h
  jz Only32Ofs
  cmp word ptr FRType[ebx+ecx],1005h
  jz Only32Ofs
  cmp word ptr FRType[ebx+ecx],1008h
  jz Only32Ofs
  cmp word ptr FRType[ebx+ecx],1006h
  jnz format_error

;-------------- get section attributes -----------------

  push edi
  test OTObjectFlags[edi+ebp],4 ;executable?
  movsx edi,FROffset[ecx+ebx]  ;can be negative!
  push edx
  pushfd
  add edx,exe_off
  mov [edi+edx+4],ds
  popfd
  jz Isdata32
  mov [edi+edx+4],cs
Isdata32:
  pop edx
  pop edi
Only32Ofs:
  pop edi
  add ebx,9
  cmp ebx,[edi+ebp+4]
  jc FixupRecord
  jmp FixupDone

;-------------- 16 bit target ------------------------

check16bit:
  cmp byte ptr FRType[ebx+ecx+1],0
  jnz format_error
  push edi
  movzx edi,FRObject[ecx+ebx]
  movzx eax,FRItem[ecx+ebx]
  lea edi,[edi*2+edi-3]
  lea edi,[edi*8+esi]       ; edi = (edi*3-3)*8 + esi

  cmp byte ptr FRType[ebx+ecx],2
  jnz FuNoSel16
  test OTObjectFlags[edi+ebp],4 ;executable?
  movsx edi,FROffset[ecx+ebx]   ;can be negative!
  push edx
  pushfd
  add edx,exe_off
  mov word ptr [edi+edx],ds
  popfd
  jz IsdataSel16
  mov word ptr [edi+edx],cs
IsdataSel16:
  pop edx
  pop edi
  add ebx,5
  cmp ebx,[edi+ebp+4]
  jc FixupRecord
  jmp FixupDone

FuNoSel16:
  add eax,OTReserved[edi+ebp]  
  push edi
  movsx edi,FROffset[ecx+ebx] ;can be negative!
  push edx
  cmp FRType[ebx+ecx],8
  jnz NoRel16
  sub eax,edx
  sub eax,edi
  sub eax,4
NoRel16:
  add edx,exe_off
  mov [edi+edx],ax
  cmp word ptr FRType[ebx+ecx],5
  jz Fu16_16
  mov [edi+edx],eax
Fu16_16:
  pop edx
  pop edi
  cmp word ptr FRType[ebx+ecx],7
  jz OnlyOfs
  cmp word ptr FRType[ebx+ecx],5
  jz OnlyOfs
  cmp word ptr FRType[ebx+ecx],8
  jz OnlyOfs
  cmp word ptr FRType[ebx+ecx],6
  jnz format_error

  push edi
  test OTObjectFlags[edi+ebp],4 ;executable?
  movsx edi,FROffset[ecx+ebx] ;can be negative!
  push edx
  pushfd
  add edx,exe_off
  mov word ptr [edi+edx+4],ds
  popfd
  jz Isdata16
  mov word ptr [edi+edx+4],cs

Isdata16:
  pop edx
  pop edi

OnlyOfs:
  pop edi
  add ebx,7
  cmp ebx,[edi+ebp+4]
  jc FixupRecord

FixupDone:

  add edi,4
  add edx,LEPageSize[ebp]
  dec LENumberPages[ebp]
  jnz FixupPage

 ; int 3

  mov eax,exeimagesize
  mov ebx,exe_off
  add eax,ebx

  mov esi,LEEntrySection[ebp]
  lea esi,[esi*2+esi-3]
  lea esi,[esi*8+ebp]
  add esi,LEObjectTable[ebp]
  mov ebx,OTReserved[esi]
  add ebx,LEEntryOffset[ebp]

  mov esi,LEStackSection[ebp]
  lea esi,[esi*2+esi-3]
  lea esi,[esi*8+ebp]
  add esi,LEObjectTable[ebp]
  mov eax,OTReserved[esi]
  add eax,LEInitialESP[ebp]

  mov esp,eax

  push ebx
  mov _replace_first_offset,ebx

  mov cl,[ebx]
  mov _replace_first_data,cl
  mov byte ptr[ebx],0cch  ;INT 3h

  call qdebug
   ;EAX == ESP to start @
   ;EBX == EIP to start @

  xor eax,eax
  xor ebx,ebx
  xor ecx,ecx
  xor edx,edx
  xor esi,esi
  xor edi,edi
  xor ebp,ebp
  push ds
  pop fs
  mov gs,eax
  mov es,pspsel

  inc _replace_first

  ret

le_loader endp



