strcpy proc,s1off:dword,s2off:dword
  ;s1=s2
  pushad
  mov edi,s1off
  mov esi,s2off
  callp strlen,esi
  mov ecx,eax
  inc ecx
  rep movsb
  popad
  mov eax,s1off
  ret
strcpy endp

strlen proc uses edi ecx,off:dword
  mov edi,off
  or ecx,-1  ;faster than mov ecx,-1 (2 bytes shorter)
  xor al,al
  repnz scasb
  not ecx
  dec ecx
  mov eax,ecx
  ret
strlen endp

.data?
  h db ?  ;('a' or 'A') - 10
  tss db ?
  ts db 34 dup (?)

.code
_num2str_:
  ;eax = # to decode
  ;ebx = radix
  mov edi,offset ts+33
  mov byte ptr[edi],0
  dec edi
  mov ecx,32  ;the MAX
num2str_2:
  xor edx,edx
  div ebx
  .if dl<10
    add dl,'0'
  .else
    add dl,h
  .endif
  mov [edi],dl
  dec edi
  dec ecx
  jnz num2str_2
  .while edi!=offset ts
    mov bptr[edi],'0'
    dec edi
  .endw
  mov bptr[edi],'0'
  ret

copyit:
; esi => edi
;copies a string (and removes unneeded 0s)
  mov ebx,edi
  mov al,bptr[esi]
  .if (al=='-')
    movsb
    mov al,bptr[esi]
  .endif
  .if (al=='0')
    .while al=='0'
      lodsb
    .endw
    stosb
  .endif
  .if !al  ;the # is zero
    mov edi,ebx
    mov bptr[edi],'0'
    mov bptr[edi+1],0
    ret
  .endif
  .while al
    lodsb   ;can't use movsb : must get al loaded
    stosb
  .endw
  ret

num2str proc,a:dword,off:dword,rax:byte
  mov h,'a'-10
jumpin1::
  pushad
  xor ebx,ebx
  mov bl,rax
  .if (bl>36) || (bl<2)  ;tolerance
    mov ebx,off
    mov bptr[ebx],0
    popad
    mov eax,off
    ret
  .endif
  mov eax,a
  call _num2str_
  mov edi,off
  mov esi,offset ts
  call copyit

  popad
  mov eax,off
  ret
num2str endp
