;Included by ftoa.asm

etoa proc, a:REAL8, string:dword, decimals:dword
  ;print decimal part then 'e' then exponential part
  
  local _ws:byte                        ;whole part sign
  local __r_1:real8,__t_w1:word,__t_d1:dword
  local __r_int:real8,__r_rnd:real8,__r_rnd2:real8,__r_pow:real8
  local __t_rndd1:dword,__t_rndd2:dword

  pushad
  
  ;Do not use fround here or it will change the output
  
  fld a
  mov edi,string
  call chk_nan_inf                      ;frees st(0)
  .if eax
    popad
    mov eax,string
    ret
  .endif
  
  fld a
  ftst                                  ;cmp with 0.0  ;must account for decimals
  fstsw ax
  ffree st
  _fwait
  sahf
  .if zero?
    callp _ftoa_,a,edi,decimals         ;0.000000
    callp strlen,edi
    add edi,eax
    callp strcpy,edi,"e+00"
    popad
    mov eax,string
    ret
  .endif
  mov _ws,0
  .if carry?                            ;negative #
    mov _ws,1
    xor bptr[a+7],80h                   ;remove sign bit
  .endif

  callp log10,a                         ;get exponent part
  fstp __r_1
  _fwait
  frnd __r_1,1                          ;round .9999999 to 1
  fint __r_1                            ;chop dec part
  fld __r_1
  fistp __t_w1                          ;save here
  _fwait

  callp pow10,__r_1                     ;find 10 ** tmp
  fld a
  fxch
  fdivp st(1),st                        ;find 'a' / (10 ** tmp) which will leave the dec part
  fstp __r_1                            ;save dec part
  _fwait
  frnd __r_1,decimals                   ;round 0.9999 to 1.0
  
  .if _ws                               ;put in neg #
    mov al,'-'
    stosb
  .endif
  callp _ftoa_,__r_1,edi,decimals,0     ;0-means do not use fround/frnd
  callp strlen,edi
  add edi,eax
  
  mov al,'e'
  stosb
  mov bx,__t_w1
  .if bx & 8000h
    neg bx
    mov al,'-'
    stosb
  .else
    mov al,'+'
    stosb
  .endif
  .if bx<10                             ;make sure there are at least 2 digits (as BC)
    mov al,'0'
    stosb
  .endif
  callp num2str,bx,edi,10
  
  popad
  mov eax,string
  
  ret
etoa endp
