include src\qlib.inc
include src\video.inc
include video.inc
include alloc.inc
include dos.inc
include string.inc
include stdio.inc

.data?  ;starts DWORD aligned
font dd ?
_v_font_x dd ?
_v_font_y dd ?
fontcharsiz dd ? ;size of each char (x*y*bypp)
fontclr dd ?     ;font color (only if fonttyp=1 or 2)
fonttyp db ?     ;font type
                 ;  0=normal
                 ;  1=single color (byte packed) [Obsolete]
                 ;  2=single color (bit packed)  (NEW : v2.07 Beta #4)
fnttmp db (sizeof g_fnthead) dup (?)

.code
align 4
g_setfnt proc uses ebx ecx edx esi,fbuf:dword
  pushad  ;FIX : v2.03 Beta #5 : this was not here
  mov esi,fbuf
  movzx eax,[esi].g_fnthead.x
  movzx ebx,[esi].g_fnthead.y
  movzx ecx,[esi].g_fnthead.bypp
  mov dl,[esi].g_fnthead.flg
  mov fonttyp,dl

  mov _v_font_x,eax
  mov _v_font_y,ebx
  mul ebx
  mul ecx
  mov fontcharsiz,eax
  mov font,esi

  popad
  xor eax,eax
  ret
g_setfnt endp

g_getfnt proc
  mov eax,font
  ret
g_getfnt endp

;FONT files now have a header
align 4
g_loadfnt proc,nam:dword
  local h:word

  pushad
  mov font,0
  callp open,nam,O_BINARY or O_RDONLY
  cmp eax,ERROR
  jnz @f
  popad
  mov eax,ERROR
  ret
@@:
  mov h,ax
  callp read,ax,offset fnttmp,sizeof g_fnthead
  .if eax!=sizeof g_fnthead
bad:
    callp free,font
    mov font,0
    callp close,h
    popad
    mov eax,ERROR
    ret
  .endif
  mov esi,offset fnttmp
  cmp dptr[esi],01a544e46h  ;FNT,26
  jnz bad
  movzx eax,[esi].g_fnthead.x
  movzx ebx,[esi].g_fnthead.y
  movzx ecx,[esi].g_fnthead.bypp
  mov dl,[esi].g_fnthead.flg

  .if (dl != 2) && (dl)   ;FIX : v2.10b : This was wrong! (could only load bitpacked fonts!)
    jmp bad
  .endif

  mov fonttyp,dl
  .if !dl
    mov fontclr,0  ;not used
  .else
    .if ecx==1
      mov fontclr,31 ;default White colour
    .else
      mov fontclr,0ffffffffh  ;White colour
    .endif
  .endif
  mov _v_font_x,eax
  mov _v_font_y,ebx

  mul ebx
  mul ecx
  mov fontcharsiz,eax
  mov ebx,256  ;# of chars
  mul ebx
  .if fonttyp & 2
    mov bl,al
    shr eax,3  ;/8
    test bl,7
    .if !zero?
      inc eax
    .endif
  .endif
  mov ebx,eax
  add eax,sizeof g_fnthead
  callp malloc,eax
  .if eax==ERROR
    jmp bad
  .endif
  mov font,eax
  mov edx,eax
  mov esi,offset fnttmp
  mov edi,eax
  mov ecx,sizeof g_fnthead
  copyECX  ;destroys AL
  mov ecx,edx
  add ecx,sizeof g_fnthead
  callp read,h,ecx,ebx
  cmp eax,ebx
  jnz bad
  callp close,h
  popad
  mov eax,font
  ret
g_loadfnt endp

;g_fntcolor proc,_font:dword,col:byte   ;changes color of font
;OLD : This routine is outdated (obsolete)
; see: g_setfntcolor

align 4
g_setfntcolor proc,clr:dword   ;NEW : v2.03 Beta #5
  .if !fonttyp
    mov eax,ERROR
    ret
  .endif
  mov eax,clr
  mov fontclr,eax
  xor eax,eax
  ret
g_setfntcolor endp

align 4
g_putch proc,x:dword,y:dword,char:byte
  pushad

  xor eax,eax
  mov al,char
  mul fontcharsiz
  .if fonttyp & 2
    ;Convert EAX into bitpack format
    ; NOTE : Each font char must be BYTE aligned!
    shr eax,3
  .endif
  mov esi,eax
  add esi,font
  add esi,sizeof g_fnthead

  mov eax,x
  mov ebx,y
  mov ecx,eax
  mov edx,ebx
  add ecx,_v_font_x
  add edx,_v_font_y
  dec ecx
  dec edx

  test fonttyp,2
  .if zero?
    ;normal font
    callp g_put0,esi,eax,ebx,ecx,edx
  .else
    callp g_putb0,esi,eax,ebx,ecx,edx,fontclr
  .endif

  popad
  ret
g_putch endp

align 4
g_printxy proc,x:dword,y:dword,s:dword
  pushad
  mov esi,s
  mov ebx,x
  mov ecx,y
  jmp gputstr_1
gputstr_2:
  callp g_putch,ebx,ecx,dl
  add ebx,_v_font_x
  inc esi
gputstr_1:
  mov dl,[esi]
  cmp dl,13
  jz enter1
  cmp dl,10
  jz ignore
  cmp dl,0
  jnz gputstr_2
  popad
  ret
enter1:
  inc s
  mov x,0
  mov eax,_v_font_y
  add y,eax
  jmp gputstr_1
ignore:
  inc s
  jmp gputstr_1
g_printxy endp

align 4
g_printf proc,x:dword,y:dword,str1:dword,argv:vararg
  local siz:dword
  pushad

  lea eax,argv
  callp _vprintf_siz,str1,eax

  mov siz,eax
  sub esp,eax
  lea eax,argv
  mov edi,esp
  callp vsprintf,edi,str1,eax

  callp g_printxy,x,y,esp

  add esp,siz
  popad
  xor eax,eax
  ret
g_printf endp

_endseg

end
