/*****************************************************************************
   MODULE: rcgetf.c
  PURPOSE: recio column delimited floating point input functions
COPYRIGHT: (C) 1994-1996, William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.15
  RELEASE: October 26, 1996
*****************************************************************************/

#include <ctype.h>
#include <errno.h>
#include <float.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "recio.h"

extern int _risready(REC *rp, int mode);
extern char *_rfldstr(REC *rp, size_t len);
extern char *_rerrs(REC *rp, int errnum);

#define rcol(rp) (rp->r_colno)

/****************************************************************************/
static double                /* return floating point number                */
    _rcgetd(                 /* get flt pt number from col delim stream     */
        REC   *rp,           /* pointer to record stream                    */
        size_t begcol,       /* field inclusive beginning column            */
        size_t endcol,       /* field inclusive ending column               */
        double negmin,       /* inclusive valid negative minimum value      */
        double negmax,       /* inclusive valid negative maximum value      */
        double posmin,       /* inclusive valid positive minimum value      */
        double posmax)       /* inclusive valid positive maximum value      */
/****************************************************************************/
{
    double result=0.0;       /* result to return */
    double val;              /* conversion value */
    char *fldptr;            /* pointer to field string */
    char *endptr;            /* pointer to first invalid field char */
    char *fldp;              /* another pointer to field string */

    if (_risready(rp, R_READ)) { 
      if (endcol >= begcol && begcol >= rbegcolno(rp)) { 
        rcol(rp) = begcol - rbegcolno(rp); 
        fldptr = _rfldstr(rp, endcol-begcol+1); 
        if (fldptr) { 
          for (;;) { 
            for (fldp=fldptr; *fldp; fldp++) {if (!isspace(*fldp)) break;} 
            if (*fldp) { 
              endptr = fldptr; 
              errno = 0; 
              val = strtod(fldptr, &endptr); 
              while (isspace(*endptr)) endptr++; 
              if (errno==ERANGE || !*endptr) { 
                if (!errno) { 
                  if (!val || (val >= negmin && val <= negmax) || 
                              (val >= posmin && val <= posmax)) { 
                        result = val;
                        goto done;
                  }
                } /* data out of range */ 
                fldptr = _rerrs(rp, R_ERANGE); 
                if (fldptr) { continue; } else { goto done; } 
              } /* invalid data */ 
              fldptr = _rerrs(rp, R_EINVDAT); 
              if (fldptr) { continue; } else { goto done; } 
            } /* missing data */ 
            fldptr = _rerrs(rp, R_EMISDAT); 
            if (fldptr) { continue; } else { goto done; } 
          } 
        }
      } /* column args reversed or tried to start before first column */
      rseterr(rp, R_EINVAL);
    }
done: 
    return result; 
}

/****************************************************************************/
/* column delimited floating point input functions                          */
/****************************************************************************/
float rcgetf(REC *rp, size_t begcol, size_t endcol)
{
    return (float) _rcgetd(rp, begcol, endcol, 
     -FLT_MAX, -FLT_MIN, FLT_MIN, FLT_MAX);
}

double rcgetd(REC *rp, size_t begcol, size_t endcol)
{
    return _rcgetd(rp, begcol, endcol, 
     -DBL_MAX, -DBL_MIN, DBL_MIN, DBL_MAX);
}
